Boid = class()

function Boid:init(pos,n)
    self.position = pos
    self.velocity = vec2(0,0)
    self.num = n
    self.sprites = {asset.builtin.Space_Art.Part_Gray_Hull_1, asset.builtin.Space_Art.Part_Green_Hull_1, asset.builtin.Space_Art.Part_Red_Hull_1, asset.builtin.Space_Art.Part_Yellow_Hull_1}
    self.sprite = self.sprites[math.floor(math.random(1,#self.sprites))]
end

function Boid:draw()
    pushMatrix()
    self.position = self.position + self.velocity
    translate(self.position:unpack())
    rotate(-90)
    rotate(math.deg(math.atan(self.velocity.y,self.velocity.x)))
    --rotate(self.velocity:angleBetween(vec2(0,100)))
    sprite(self.sprite, 0,0,20,20)
    text(self.num)
    popMatrix()
end

function Boid:touched(touch)
end
function Boid:getNum()
    return self.num
end
function Boid:getPos()
    return self.position
end
