-- Boids by TimurEke
function setup()
    parameter.number("affectFac",0.1,40,10)
    parameter.number("goToCenterFac", 1, 16, 10)
    parameter.number("stayAwayFac", 1, 100, 100)
    parameter.number("matchVelFac", 1, 20, 12) 
    parameter.number("goToPlaceFac", 1, 20, 12)
    parameter.number("stayAwayFac2", 1,20, 12)
    lim = 80
    boids = {} 
    for i = 1, lim do
        table.insert(boids, Boid(vec2(math.random(100,WIDTH-100),math.random(100,HEIGHT-100)),i))
    end
    bgImg = gradientImage(color(67, 158, 236), color(67, 236, 221))
end

function gradientImage(color1, color2)
    local img = image(WIDTH, HEIGHT)
    setContext(img)
    for y=1, HEIGHT do
        local t = y/HEIGHT
        local r = color1.r*(1-t) + color2.r * t
        local g = color1.g*(1-t) + color2.g * t
        local b = color1.b*(1-t) + color2.b * t
        stroke(r,g,b)
        strokeWidth(1)
        line(0, y, WIDTH, y)
    end
    setContext()
    return img
end

function draw()
    background(40, 40, 50)
    pushStyle()
    spriteMode(CENTER)
    sprite(bgImg, WIDTH/2, HEIGHT/2)
    popStyle()
    for i, b in ipairs(boids) do
        b:draw()
    end
    updateBoids()
end
function updateBoids()
    v = vec2()
    for i, b in ipairs(boids) do
        v = v + goToCenter(b) / goToCenterFac
        v = v + stayAway(b)/stayAwayFac2
        v = v + matchVel(b) /matchVelFac
        v = v + matchNearestVel(b)/matchVelFac*5
        v = v + goToPlace(b) /goToPlaceFac 
        v = v + stayInBounds(b)
        v = v * (0.9+math.random()/5)
        limVel(b)
        b.velocity = b.velocity + v/affectFac
    end
end
function goToCenter(bJ)
    pcJ = vec2()
    for i, b in ipairs(boids) do
        if b == bJ then
        else
                pcJ = pcJ + b.position
        end
    end
    pcJ = pcJ / (lim-1)

    return (pcJ - bJ.position)/50
end
function stayAway(bJ)
    c = vec2()
    for i, b in ipairs(boids) do
        if b == bJ then
        else
            if bJ.position:dist(b.position) < stayAwayFac then
                    c = c - (b.position - bJ.position)/50
            end
        end
    end
    return c 
end
function matchVel(bJ)
    pvJ = vec2()
    for i, b in ipairs(boids) do
        if b == bJ then
        else
                pvJ = pvJ + b.velocity
        end
    end
    pvJ = pvJ / (lim-1)
    return (pvJ - bJ.velocity)/50
end

function matchNearestVel(bJ)
    distance = math.maxinteger
    for i, b in ipairs(boids) do
        if b == bJ then
        else
            if bJ.position:dist(b.position) < distance then
                distance = bJ.position:dist(b.position)
                nearestVel = b.velocity
            end
        end
    end
    return nearestVel/50
end
function goToPlace(b)
    place = vec2(WIDTH/2, HEIGHT-300)
    return(place - b.position)/50
end
function stayInBounds(b)
    c = vec2()
    if b.position.x < 0 then
        c = c + vec2(3,0) 
    elseif b.position.x > WIDTH then
        c = c + vec2(-3,0) 
    end
    if b.position.y < 0 then
        c = c + vec2(0,3) 
    elseif b.position.y > HEIGHT then
        c = c + vec2(0,-3) 
    end
    return c
end
function limVel(b)
     vlim = 5
    len = b.velocity:len()
    if math.abs(len) > vlim then
        b.velocity = b.velocity:normalize()*vlim
    end
end
function touched(touch)
        v = vec2()
        for i, b in ipairs(boids) do
            touchpos = vec2(touch.x, touch.y)
            v = (touchpos - b.position) / 200
            limVel(b)
            if touch.state == BEGAN then
                b.velocity = b.velocity - v/v:lenSqr() *200
            else
                 b.velocity = b.velocity + v 
            end
        end
end

