
local t = {
    s = 0
}

local function test1()
    print("test 1")
    for k,v in pairs(viewer) do
        print(k, v)
    end
end

local function test2()
    print("test 2")
    print(asset.documents.all)
    for _,e in ipairs(asset.documents.all) do
        print(e.name)
    end
end

local function test3()
    print("test 3")
    print(asset.documents)
    print(asset.webrepo_version)
    print(asset .. "webrepo_version")
end

local function test4()
    print("test 4")
    print(layout.safeArea.bottom)
end

local function test5()
    print("test 5")
    local asyncFn = async(function(message)
        print(message)
        return "Message sent!"
    end)
    
    -- Call the async function to print 'Hello World!'
    local pr = asyncFn("Hello Async World!")
    
    -- This gets printed before the async one above
    print("Hello World!")
    
    -- Print the result once the async function has returned
    local result = await(pr)
    print(result)
end

local function test6()
    print("test 6")
    
    -- Async functions return a Promise object
    local sendMessage = async(function(delay)
        delay = delay or 1 -- Delay for 1 second by default
        Thread.sleep(delay)
        if delay > 2 then
            error("Failed to send message!")
        end
        return "Message sent!", 7
    end)
    
    -- Call the async 'sendMessage' function
    sendMessage()
    -- Add a success handler
    :thenDo(function(msg, val)
        print(msg, val)
    end)
    -- Add an error handler
    :catch(function(err)
        objc.warning("Err: " .. err)
    end)
    -- Add a 'finally' handler
    :finally(function()
        print("Promise chain complete!")
    end)
    
    -- Use of 'await()' to wait for a Promise
    -- to be fulfilled.
    --
    -- Try to send a message with a delay of 3!
    -- > 2 seconds throws an error so we add
    -- a 'catch' handler here to catch the error.
    --
    -- Prints 'nil'
    print(await(sendMessage(3):catch(function()end)))
    
    -- Same thing but without the error handler.
    -- This causes a crash instead
    print(await(sendMessage(3)))
end

local function test7()
    print("test 7")
    
    -- Promise based http request
    http.requestProm("https://baconipsum.com/api/?type=meat-and-filler&paras=1&format=text")
    :thenDo(function(data, status, headers)
        print(data)
    end)
    :catch(function(err)
        objc.warning(err)
        dbg()
    end)
    
    -- Wait for the promise to be fulfilled
    print( await(http.requestProm("https://baconipsum.com/api/?type=meat-and-filler&paras=1&format=text")) )
end

function setup()
    --test1()
    --test2()
    --test3()
    --test4()
    --test5()
    --test6()
    test7()
end

function draw()
    -- Print tweened value and trigger the debug break
    -- when it finishes
    print("draw", t.s)
    background(128)
    dbg(t.s == 1.0)
end

function touched(touch)
    if touch.state == BEGAN then
        tween(1.0, t, { s = (((t.s == 0.0) and 1.0) or 0.0) })
    end
end
