-- Various functions overridden to run on the main thread.
-- If this is not done, most of these functions will simply
-- not work at all from a Thread.

local http_request = http.request
http.request = function(url, success, fail, parameters)
    Thread.runOnMain(http_request, url, Thread.callback(success, true), Thread.callback(fail, true), parameters)
end

function http.requestProm(url, parameters)
    return Promise(function(resolve, reject)
        http.request(url, resolve, reject, parameters)
    end)
end

function http.requestSync(url, parameters)
    
    local result = nil
    local sem = Semaphore()
    
    Thread.runOnMain(http_request, url,
        function(response, status, headers) -- Success
            result = { response, status, headers }
            sem:signal()
        end,
        function(err) -- Fail
            result = { nil, err }
            sem:signal()
        end, parameters)
    
    sem:wait()
    
    return table.unpack(result)
end
