
local function GenerateHTMLDoc()
    local tabs = listProjectTabs()
    
    for _,tab in ipairs(tabs) do
        
        -- Read the source
        local f = io.open((asset[tab].path), "r")
        local src = f:read("*a") f:close()
        
        for func in src:gmatch("--%s*@function%s*(.-)%(") do
            print(func)
        end
    end
    
    return [[
    <!DOCTYPE html>
<html>
<body style="background-color:white;">

<h1>This is a heading</h1>
<p>This is a paragraph.</p>

</body>
</html>
    ]]
end

function AutoDoc()
    
    viewer.mode = FULLSCREEN
    
    -- Open the WebView
    local wv = WebView()
    wv:loadHTML(GenerateHTMLDoc())
    wv:show()
    
    -- Do not return
    while true do
        yield()
    end
end
