-- Based on the 'JavaScript' lib available on WebRepo.
-- This is a highly stripped down version of the library
-- above intended to serve a static page only.

local WebView = class()
local WebViewURLSchemeHandler = class()

-- Alias
DocViewer = WebView

-- Default URL scheme handler 'codea://' reads resources from the
-- current project's asset folder.
function WebViewURLSchemeHandler:init()
    if WebViewURLSchemeHandler.Handler == nil then
        WebViewURLSchemeHandler.Handler = objc.delegate("WKURLSchemeHandler")
        
        local mimeType = {
            txt         = "text/plain",
            png         = "image/png",
            css         = "text/css",
            js          = "text/javascript"
        }
        
        WebViewURLSchemeHandler.Handler.webView_startURLSchemeTask_ = function(self, objWebView, objUrlSchemeTask)
                
            local url = objUrlSchemeTask.request.URL
                
            -- Get the file path
            local path = url.absoluteString:gsub("codea://", "")
            path = socket.url.unescape(path)
            local ext = path:match(".*%.(.-)$")
                
            -- Read the file into NSData
            local data = objc.cls.NSData:dataWithContentsOfFile_(asset.path .. "/" .. path)
                
            -- Create the response
            local response = objc.cls.NSHTTPURLResponse:alloc()
            response:initWithURL_statusCode_HTTPVersion_headerFields_(url, 200, "HTTP/1.1", {
                ["Access-Control-Allow-Origin"] = "*",
                ["Content-Type"] = mimeType[ext] or "application/octet-stream"
            })
                
            objUrlSchemeTask:didReceiveResponse_(response)
            objUrlSchemeTask:didReceiveData_(data)
            objUrlSchemeTask:didFinish()
        end
    end
    self.handler = WebViewURLSchemeHandler.Handler()
end

function WebViewURLSchemeHandler:register(config)
    config:setURLSchemeHandler_forURLScheme_(self.handler, "codea")
end

function WebView:init(htmlAsset)
    Thread.runOnMain(function()
        -- Create the WebView config
        local config = objc.cls.WKWebViewConfiguration()
        self.urlSchemeHandler = WebViewURLSchemeHandler()
        self.urlSchemeHandler:register(config)
        
        -- New view
        self.view = objc.cls.WKWebView:alloc()
        self.view:initWithFrame_configuration_(objc.viewer.view.bounds, config)
        
        -- Remove old WKWebView view
        if objc.viewer.view.subviews[2].Class == "WKWebView" then
            objc.viewer.view.subviews[2]:removeFromSuperview()
        end
        
        -- Place the WKWebView over the EAGLView
        objc.viewer.view:insertSubview_atIndex_(self.view, 1)
        
        -- Ensure cleanup is done
        registerTerminator(function()
            self.view:removeFromSuperview()
        end)
    end)
    
    -- Trigger a page load
    self:loadHTML(htmlAsset)
end

local function loadHTMLFromFile(view, htmlAsset)
    
    -- Escape spaces
    local path = htmlAsset.path:gsub(" ", "%%20")
    
    Thread.runOnMain(function()
        local request = objc.cls.NSURLRequest:requestWithURL_cachePolicy_timeoutInterval_(
            objc.cls.NSURL:URLWithString_("file://" .. path),
            objc.enum.NSURLRequestCachePolicy.NSURLRequestReloadIgnoringCacheData,
            5.0)
        view:loadRequest_(request)
    end)
end

function WebView:loadHTML(obj)
    loadHTMLFromFile(self.view, obj)
end
