local gmt = getmetatable(_G)
if gmt and gmt.___CODEA_PLUS then
    return
end
assert(gmt == nil, "Global metatable modifications are not compatible with 'Codea+'")
    
    
local wrappers = {}
    
gmt = {
    __index = function(t, k)
        local w = wrappers[k]
        if w then
            return function(...)
                w.wfn(w.fn, ...)
            end
        end
    end,
    __newindex = function(t, k, v)
        if wrappers[k] then
            wrappers[k].fn = v
        else
            rawset(t, k, v)
        end
    end,
    ___CODEA_PLUS = true
}
setmetatable(_G, gmt)

function __wrapGlobal(name, fn)
    wrappers[name] = {
        wfn = fn,
        fn = nil
    }
end

function __getWrappedGlobal(name)
    return wrappers[name].fn
end
