--- @class Semaphore
-- Semaphore object for thread coordination
Semaphore = class()

--- @function Semaphore ()
-- Semaphore constructor.
function Semaphore:init()
    self.count = 0
    self.waiting = 0
end

--- @function Semaphore:signal ()
-- Increments the semaphore value.
function Semaphore:signal()
    self.count = self.count + (count or 1)
end

--- @function Semaphore:signalAll ()
-- Increase the semaphore value by the number of threads currently waiting on this semaphore.
function Semaphore:signalAll()
    self.count = self.count + self.waiting
end

--- @function Semaphore:wait (fast)
-- Yield the current thread until the semaphore value is > 0.
-- This will return immediately if the semaphore value is already > 0.
-- @param fast (default false)
-- When false, execution will not resume on this thread until the next frame at the earliest.
-- When true, execution can return to this thread in the current frame.
function Semaphore:wait(fast)
    self.waiting = self.waiting + 1
    while self.count == 0 do
        yield(fast)
    end
    self.count = self.count - 1
    self.waiting = self.waiting - 1
end
