----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
-- Codea+Semaphore

local function test1()
    print("test 1")
    local asyncFn = async(function(message)
        print(message)
        return "Message sent!"
    end)
    
    -- Call the async function to print 'Hello World!'
    local pr = asyncFn("Hello Async World!")
    
    -- This gets printed before the async one above
    print("Hello World!")
    
    -- Print the result once the async function has returned
    local result = await(pr)
    print(result)
end

local function test2()
    print("test 2")
    
    -- Async functions return a Promise object
    local sendMessage = async(function(delay)
        delay = delay or 1 -- Delay for 1 second by default
        Thread.sleep(delay)
        if delay > 2 then
            error("Failed to send message!")
        end
        return "Message sent!", 7
    end)
    
    -- Call the async 'sendMessage' function
    sendMessage()
    -- Add a success handler
    :next(function(msg, val)
        print(msg, val)
    end)
    -- Add an error handler
    :catch(function(err)
        objc.warning("Err: " .. err)
    end)
    -- Add a 'finally' handler
    :finally(function()
        print("Promise chain complete!")
    end)
    
    -- Use of 'await()' to wait for a Promise
    -- to be fulfilled.
    --
    -- Try to send a message with a delay of 3!
    -- > 2 seconds throws an error so we add
    -- a 'catch' handler here to catch the error.
    --
    -- Prints 'nil'
    print(await(sendMessage(3):catch(function()end)))
    
    -- Same thing but without the error handler.
    -- This causes a crash instead
    print(await(sendMessage(3)))
end

function setup()
    --test1()
    --test2()
    
    GenDoc(true)
end

function draw()
    background(40, 40, 50)
end

