----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
local callbacks = {}

-- Thread to call all issued callbacks
Thread(function()

    -- Run every frame
    while true do
        
        -- Issue all callbacks
        for _, cb in ipairs(callbacks) do
            cb[1](table.unpack(cb[2]))
        end
        callbacks = {}
        
        -- Yield this frame
        Thread.yield()
    end
end):config({
    name = "Callback",
    deferred = true -- run at the end of each frame
})

local function queueCallback(fn, ...)
    table.insert(callbacks, {fn, {...}})
end

-- Returns a callback function that will execute on a thread.
function Thread.callback(fn, useSharedThread)
    if useSharedThread then
        return function(...)
            queueCallback(fn, ...)
        end
    else
        return function(...)
            Thread(fn, ...):config{
                name = "Callback",
                deferred = true -- run at the end of a frame
            }
        end
    end
end