----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
local CP_SHARED = {}
_G["codea+"] = CP_SHARED
local _G_G = _G

local kEmptyTable = {}
local coroutine = coroutine

local function uploadToBayfiles(data, name, callback)
    
    local len = string.len(data)
    
    print("Uploading " .. len .. " bytes...")
    
    local boundary = '--WRUploadsy879iuhjkn89iuwbkyjs'
    local header_b = 'Content-Disposition: form-data; name="file"; filename="' .. name .. '"\r\nContent-Type: text/plain\r\n'
    
    local s1 = '--' .. boundary .. '\r\n' ..header_b ..'\r\n'
    local s2 = data
    local s3 = '\r\n--' .. boundary ..'--\r\n'
    local source = s1 .. s2 .. s3
    local source_len = tostring(#s1 + len + #s3)
    
    http.request("https://api.bayfiles.com/upload",
        function(response, status)
            if status == 200 then
                response = json.decode(response)
                callback(response.data.file.url.short)
            end
        end,
        function(err)
            print(err)
        end,
        {
            method = "POST",
            headers = {
                ["Content-Length"] = source_len,
                ["Content-Type"] = 'multipart/form-data; boundary=' .. boundary    
            },
            data = source
        }
    )
end

local ThreadManager = class()
function ThreadManager:init()
    self.threads = {}
end

function ThreadManager:frame()
    
    local loopAgain = true
    local deadThreads = {}
    
    -- Reset 'continueExec' flag for this new frame
    for i,thr in ipairs(self.threads) do
        thr.continueExec = true
    end
    
    -- Run normal threads
    while loopAgain do
        loopAgain = false
        
        for i,thr in ipairs(self.threads) do
            if not thr.deferred then
                
                local res = table.pack(xpcall(ThreadManager.threadFrame, function(msg)
                    return self:errorHandler(msg, i)
                end, self, thr))
                
                if res[1] then
                    loopAgain = res[2] or loopAgain
                else
                    return
                end
                    
                -- Check for dead thread
                if coroutine.status(thr.co) == "dead" then
                    table.insert(deadThreads, i)
                end
            end
        end 
        
        -- Clear dead threads
        if #deadThreads > 0 then
            for i=#deadThreads,1,-1 do
                table.remove(self.threads, deadThreads[i])
            end
            deadThreads = {}
        end
    end
    
    -- Run deferred threads
    loopAgain = true
    while loopAgain do
        loopAgain = false
        
        for i,thr in ipairs(self.threads) do
            if thr.deferred then
                
                local res = table.pack(xpcall(ThreadManager.threadFrame, function(msg)
                    return self:errorHandler(msg, i)
                end, self, thr))
                
                if res[1] then
                    loopAgain = res[2] or loopAgain
                else
                    return
                end
                    
                -- Check for dead thread
                if coroutine.status(thr.co) == "dead" then
                    table.insert(deadThreads, i)
                end
            end
        end 
        
        -- Clear dead threads
        if #deadThreads > 0 then
            for i=#deadThreads,1,-1 do
                table.remove(self.threads, deadThreads[i])
            end
            deadThreads = {}
        end
    end
end
function ThreadManager:threadFrame(thr)
    if thr.continueExec == false then
        return false
    end
    
    -- Is the debugger active?
    -- Are we the thread being debugged?
    local Debugger = CP_SHARED.Debugger
    if Debugger and Debugger.thread ~= nil and thr ~= Debugger.thread then
        thr.continueExec = false
        return false
    end
    
    -- Is this thread currently sleeping?
    if thr.wakeAt and thr.wakeAt > ElapsedTime then
        thr.continueExec = false
        return false
    end
    
    Thread.current = thr
    local params = thr.params or kEmptyTable -- Use thread params by default
    thr.params = nil -- Only pass thread params once
    while true do
        local res = table.pack(coroutine.resume(thr.co, table.unpack(params)))
        if res[1] == true then
            if res[2] == true then
                -- Thread yield for another in same frame
                thr.continueExec = true
                break
            elseif res[2] ~= nil then
                Thread.current = nil
                -- Run on main
                -- TODO: pcall
                local fn = res[2]
                params = table.pack(fn(select(3, table.unpack(res))))
                Thread.current = thr
            else
                -- Thread frame complete
                thr.continueExec = false
                break
            end
        else
            -- Error
            error(res[2], -1)
        end
    end
    Thread.current = nil
    return thr.continueExec
end
function ThreadManager:addThread(thr)
    table.insert(self.threads, thr)
end
function ThreadManager:errorHandler(msg, threadIndex)
    if WRL then
        local report = WRL.CrashReport(msg)
        
        for i,thr in ipairs(self.threads) do
            report:dumpCoroutine(thr.co, thr.name, threadIndex == i)
        end
        
        report:send()
        
        self.threads = {}
    else
        return msg
    end
end
local manager = ThreadManager()

Thread = class()
function Thread:init(fn, ...)
    self.params = table.pack(...)
    self.co = coroutine.create(fn)
    manager:addThread(self)
end

function Thread.runOnMain(fn, ...)
    if coroutine.isyieldable() then
        return coroutine.yield(fn, ...)
    else
        local co, main = coroutine.running() 
        assert(main == true, "Unable to runOnMain, from across C function boundary!")
        return fn(...)
    end
end

function Thread.yield(fast)
    coroutine.yield(fast or nil)
end

function Thread.wrapMain(fn)
    return function(...)
        return Thread.runOnMain(fn, ...)
    end
end

function Thread.sleep(duration)
    assert(Thread.current ~= nil, "Cannot sleep outside of a thread!")
    Thread.current.wakeAt = ElapsedTime + duration
    Thread.yield()
    Thread.current.wakeAt = nil
end

function Thread:config(cfg)
    for k,v in pairs(cfg) do
        self[k] = v
    end
end

-- Local functions
local gsetup
local gdraw
-- Main loop thread object
Thread(function()
    if _G == _ENV then
        if gsetup then
            rawset(_G, "setup", gsetup)
            setup()
        end
        
        if gdraw then rawset(_G, "draw", gdraw) end
        while true do
            if draw then draw() end
            Thread.yield()
        end
    else
        if gsetup then
            setup = gsetup
            setup()
        elseif setup then
            setup()
        end
        
        if gdraw then draw = gdraw end
        while true do
            if draw then draw() end
            Thread.yield()
        end
    end
end):config({
    name = "MainLoop"
})
-- Intercept setup setter
GlobalIntercept("setup", function(v) gsetup = v end)
GlobalIntercept("draw", function(v) gdraw = v end)

function OnLoad()
    -- Hook into the tween update function
    -- to execute ThreadManager frames.
    _G.tween.update = function(dt)
        manager:frame()
    end
end

-- Call tween.update on its own thread once per frame
local tweenUp = _G.tween.update
Thread(function()
    while true do
        tweenUp(DeltaTime)
        Thread.yield()
    end
end):config({
    name = "Tween",
    deferred = true -- run at the end of each frame
})
