----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
local _ipairs = ipairs
local _pairs = pairs

local function cloneTable(t, clear)
    local clone = {}
    if t ~= nil then
        for k,v in _pairs(t) do
            clone[k] = v
        end
        for i,v in _ipairs(t) do
            clone[i] = v
        end
        if clear then
            for k,v in _pairs(t) do
                rawset(t, k, nil)
            end
            for i,v in _ipairs(t) do
                rawset(t, i, nil)
            end
        end
    end
    return clone
end

local ThreadCompat
local function ThreadCompatTable(obj)
    -- Don't wrap the global table/env
    if obj == _G then return obj end
        
    -- Get metatable
    local mt = getmetatable(obj)
    
    -- Remove the metatable's metatable
    if mt then
        local mtmt = getmetatable(mt)
        setmetatable(mt, nil)
    end
        
    -- If we've already been converted, return obj
    if mt and mt.___threadCompatible then
        setmetatable(mt, mtmt)
        return obj
    end
        
    -- Clone object
    local clone = cloneTable(obj, true)
        
    -- If the original metatable IS the table,
    -- the clone should do the same.
    if mt == obj then
        setmetatable(clone, clone)
    else
        setmetatable(clone, mt)
    end
        
    local nmt = cloneTable(mt)
    nmt.__index = Thread.wrapMain(function(t, k)
        return ThreadCompat(clone[k])
    end)
    nmt.__newindex = Thread.wrapMain(function(t, k, v)
        clone[k] = v
    end)
    nmt.__len = function()
        return #clone
    end
        
    local function wrapmm(name)
        nmt[name] = nmt[name] and ThreadCompat(nmt[name])
    end
        
    wrapmm("__add")
    wrapmm("__sub")
    wrapmm("__mul")
    wrapmm("__div")
    wrapmm("__mod")
    wrapmm("__pow")
    wrapmm("__unm")
    wrapmm("__idiv")
    wrapmm("__band")
    wrapmm("__bor")
    wrapmm("__bxor")
    wrapmm("__bnot")
    wrapmm("__shl")
    wrapmm("__shr")
    wrapmm("__add")
    wrapmm("__concat")
    wrapmm("__eq")
    wrapmm("__lt")
    wrapmm("__le")
    wrapmm("__call")
    wrapmm("__name")
    wrapmm("__close")
        
    nmt.___lazy = clone
    nmt.___threadCompatible = true
    setmetatable(obj, nmt)
    
    return obj
end

local function ThreadCompatUserdata(obj)
    -- Get metatable
    local mt = getmetatable(obj)
    
    -- Remove the metatable's metatable
    local mtmt = getmetatable(mt)
    setmetatable(mt, nil)
        
    -- If we've already been converted, return obj
    if mt and mt.___threadCompatible then
        setmetatable(mt, mtmt)
        return obj
    end
        
    -- Wrap functions
    local function wrapmm(name)
        mt[name] = mt[name] and ThreadCompat(mt[name])
    end
    wrapmm("__index")
    wrapmm("__newindex")
    wrapmm("__len")
    wrapmm("__add")
    wrapmm("__sub")
    wrapmm("__mul")
    wrapmm("__div")
    wrapmm("__mod")
    wrapmm("__pow")
    wrapmm("__unm")
    wrapmm("__idiv")
    wrapmm("__band")
    wrapmm("__bor")
    wrapmm("__bxor")
    wrapmm("__bnot")
    wrapmm("__shl")
    wrapmm("__shr")
    wrapmm("__add")
    wrapmm("__concat")
    wrapmm("__eq")
    wrapmm("__lt")
    wrapmm("__le")
    wrapmm("__call")
    wrapmm("__name")
    wrapmm("__close")
    
    mt.___threadCompatible = true
    
    setmetatable(mt, mtmt)
    
    return obj
end

local function ThreadCompatFunction(obj)
    return Thread.wrapMain(obj)
end

local ThreadCompatFnMap = {
    ["table"] = ThreadCompatTable,
    ["userdata"] = ThreadCompatUserdata,
    ["function"] = ThreadCompatFunction
}
ThreadCompat = function(...)
    local res = {}
    for _,obj in _ipairs({...}) do
        local fn = ThreadCompatFnMap[type(obj)]
        table.insert(res, (fn and fn(obj)) or obj)
    end
    return table.unpack(res)
end

-- Override iterator functions to work with
-- 'ThreadCompatified' objects.
ipairs = function(obj)
    local mt = getmetatable(obj)
    if mt and mt.___lazy then
        return Thread.runOnMain(_ipairs, mt.___lazy)
    else
        return _ipairs(obj)
    end
end

pairs = function(obj)
    local mt = getmetatable(obj)
    if mt and mt.___lazy then
        return Thread.runOnMain(_pairs, mt.___lazy)
    else
        return _pairs(obj)
    end
end

-- Compatify objects that are known to cause problems
_G.asset = ThreadCompat(asset)
_G.layout = ThreadCompat(layout)
_G.viewer = ThreadCompat(viewer)
_G.http.request = ThreadCompat(http.request)
_G.readText = ThreadCompat(readText)
_G.saveText = ThreadCompat(saveText)
_G.craft = ThreadCompat(craft)