----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
local _coroutine = coroutine
coroutine = {}

local running_co = nil

function coroutine.create(f)
    return Thread._wrapCoroutine(_coroutine.create(f))
end

function coroutine.resume(co, ...)
    -- Set running coroutine
    local current_co = running_co
    running_co = co
    
    -- Only do our thread management stuff if we're currently
    -- on a Codea+ managed thread.
    if Thread.current then    
        -- Wrap the coroutine in a thread to run in this
        -- thread management loop.
        co.params = {...}
        co.running = true
        co:attach() -- Attach the coroutine thread so it can run
    
        -- Keep yielding until the coroutine returns
        while co.running and not co.dead do
            Thread.yield(true)
        end
    else
        _coroutine.resume(co.co)
    end
        
    -- No longer running
    co.running = false
    
    -- Restore previously running coroutine
    running_co = current_co
    
    -- Return result
    if co.err then
        return false, co.err
    elseif co.yieldParams then
        local ret = table.unpack(co.yieldParams)
        co.yieldParams = nil
        return true, ret 
    else
        return true
    end
end
    
function coroutine.running()
    return running_co
end

function coroutine.status(co)
    if co.dead then -- dead flag
        return "dead"
    elseif running_co == co then -- running co matches
        return "running"
    elseif co.running then
        return "normal"
    else
        return "suspended"
    end
end

function coroutine.wrap(f)
    local co = coroutine.create(f)
    
    return function(...)
        local res = table.pack(pcall(coroutine.resume, co))
        if res[1] == true then
            if res[2] == true then
                return select(3, table.unpack(res))
            else
                error(res[3], 2)
            end
        else
            error(res[2], 2)
        end
    end
end

function coroutine.yield(...)
    assert(running_co ~= nil)
    running_co.running = false
    running_co.yieldParams = {...}
    running_co:detach()
    Thread.yield(true)
end