----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
--- @module Util
-- Various useful functions & utilities.

--- @function registerTerminator (func)
-- Registers a function to be called when the project is stopped.
-- This is akin to Codea's 'willClose()' function but allows multiple callback functions to be registered.
-- @param func The function to be registered as a terminator.

--- @function addTerminator (func)
-- Alias of registerTerminator().

--- @function unregisterTerminator (func)
-- Removes a previously registered function from the list of terminator functions.
-- @param func The function to be unregistered.

--- @function removeTerminator (func)
-- Alias of unregisterTerminator().
local terminators = {}
function registerTerminator(func)
    terminators[func] = func
end
function unregisterTerminator(func)
    terminators[func] = nil
end
addTerminator = registerTerminator
removeTerminator = unregisterTerminator
GlobalIntercept("willClose", function(fn)
    return function()
        for _,term in pairs(terminators) do
            term() -- call registered terminator
        end
        fn() -- call original
    end
end)
-- blank willClose to initialise the wrapper above
function _G.willClose() end
