----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------

--[[
@module: http
@desc: Modifications to Codea's built-in http.request function.
]]

--[[
@function: http.request
@desc: Identical to the built-in function but callbacks will be executed on a thread to allow for debugging within the callbacks.
@param: url string - URL to request
@param: success function - Callback to be executed in the case of a successful request.
@param: fail function - Callback to be executed in the case of a failed request.
@param: parameters table - Request parameters.
]]
local http_request = http.request
http.request = function(url, success, fail, parameters)
    http_request(url, Thread.callback(success), Thread.callback(fail), parameters)
end

--[[
@function: http.requestProm
@desc: Identical to the built-in function but returns results using a Promise object.
@param: url string - URL to request
@param: parameters table - Request parameters.
@return: Promise object that will be resolved or rejected with the results of the request.
]]
function http.requestProm(url, parameters)
    return Promise(function(resolve, reject)
        http.request(url, resolve, reject, parameters)
    end)
end

--[[
@function: http.requestSync
@desc: Identical to the built-in function but blocks waiting until the request completes (success or failure).
@param: url string - URL to request
@param: parameters table - Request parameters.
@return: In the case of a successful request, a table in the form { response, statusCode, headers }
<br>In the case of a failed request, a table in the form { nil, errorMessage }
]]
function http.requestSync(url, parameters)
    
    local result = nil
    local sem = Semaphore()
    
    http.request(url,
        function(response, status, headers) -- Success
            result = { response, status, headers }
            sem:signal()
        end,
        function(err) -- Fail
            result = { nil, err }
            sem:signal()
        end, parameters)
    
    sem:wait()
    
    return table.unpack(result)
end