-- CraftSeaBottom

-- 3D models SeaBottom_2 and FishGroup_2 are free 3D models by artist Shredder available at www.renderhub.com

viewer.mode=FULLSCREEN

function setup()
    btn={}
    rectMode(CENTER)
    assert(craft, "Include Craft as a dependency")
    scene = craft.scene()
    -- cameraFPS coordination and rotation angles
    cx,cy,cz, ax,ay,az = 0
    scene.sun.rotation = quat.eulerAngles(90,0,0)
    -- if want artificially bright colors on sea bottom uncomment next line
    --    scene.ambientColor = color(255,255,255)   
    skyMaterial = scene.sky.material
    skyMaterial.horizon = color(0, 203, 255, 255)
    skyMaterial.sky = color(0,255,255)
    
    -- create instance of fps camera and set position in scene
    cameraFPS = cameraClass()
    cameraFPS.cameraX, cameraFPS.cameraY, cameraFPS.cameraZ = -7, 1.18, -17
    
    -- define distance to detect fps camera running into environment
    obstructionDistance = 0.2
    obstructionRadius = 0.4
    
    --  angle variable for setting up fish rotation
    angle = 0
    
    -- setup seabottom and fish model in sea
    SeaBottom = scene:entity()
    SeaBottom.model = craft.model(asset.SeaBottom_2_obj)
    FishGroup = scene:entity()
    FishGroup.model = craft.model(asset.FishGroup_2_obj)
    -- add rigidbody structure to SeaBottom and FishGroup so can detect when when run into either
    SeaBottom:add(craft.rigidbody, STATIC)
    SeaBottom:add(craft.shape.model, SeaBottom.model)
    FishGroup:add(craft.rigidbody, STATIC)
    FishGroup:add(craft.shape.model, FishGroup.model)
    --    
    SeaBottom.scale = vec3(0.01,0.01,0.01)
    FishGroup.scale = vec3(0.01,0.01,0.01)   
end

function draw()
    background(0)
    update(DeltaTime)
    cx,cy,cz,ax,ay,az= cameraFPS:updateCameraPos()
    scene.camera.position = vec3(cx,cy,cz)
    scene.camera.eulerAngles= vec3(ax,ay,az)
    scene:draw()
    cameraFPS:draw()
end

-- rotate fish in a circle in the scene
function update(dt)
    local degreesPerSecond = 360/120
    angle = angle + dt*degreesPerSecond
    FishGroup.x = 2*math.sin(math.rad(angle))
    FishGroup.z = 2*math.cos(math.rad(angle))
    FishGroup.eulerAngles = vec3(0, -angle + 90, 0)
end

function touched(t)
    cameraFPS:touched(t)
end

function sizeChanged()
    cameraFPS:moveButtonCloser(cameraFPS)
end

function checkObstruction()
    -- compute coordinate for next move then spherecast a sphere to it and see if it hits it (if so, obstruction = true)
    local cameraX2=scene.camera.x+x
    local cameraY2=scene.camera.y+y
    local cameraZ2=scene.camera.z+z 
    local direction = vec3(cameraX2,cameraY2,cameraZ2) - vec3(scene.camera.x,scene.camera.y,scene.camera.z)
    obstruction = scene.physics:spherecast(vec3(cameraX2,cameraY2,cameraZ2), direction, obstructionDistance, obstructionRadius)  
end




