function cube(s, depth)
    -- all the unique vertices that make up a cube
    local vertices = {
    vec3(-0.5, -0.5,  0.5), -- Left  bottom front
    vec3( 0.5, -0.5,  0.5), -- Right bottom front
    vec3( 0.5,  0.5,  0.5), -- Right top    front
    vec3(-0.5,  0.5,  0.5), -- Left  top    front
    vec3(-0.5, -0.5, -0.5), -- Left  bottom back
    vec3( 0.5, -0.5, -0.5), -- Right bottom back
    vec3( 0.5,  0.5, -0.5), -- Right top    back
    vec3(-0.5,  0.5, -0.5), -- Left  top    back
    }

    -- 6 quadiralateral faces (anticlockwise)
    local faces = {
    -- Front
    {vertices[1], vertices[2], vertices[3], vertices[4]},
    -- Right
    {vertices[2], vertices[6], vertices[7], vertices[3]},
    -- Back
    {vertices[6], vertices[5], vertices[8], vertices[7]},
    -- Left
    {vertices[5], vertices[1], vertices[4], vertices[8]},
    -- Top
    {vertices[4], vertices[3], vertices[7], vertices[8]},
    -- Bottom
    {vertices[5], vertices[6], vertices[2], vertices[1]},
    }

    --recursive subdivide function
    local origin = vertices[5]
    local tOri = vec2(0.5,0.5)
    local verts, norms, cols, texC = {}, {}, {}, {}
    local rnd = math.random

    local function subdivide(f, depth, n, c, t)
        if depth == 0 then --triangulate
            local tc = {vec2(f[1][t.x], f[1][t.y])+tOri, vec2(f[2][t.x], f[2][t.y])+tOri,vec2(f[3][t.x], f[3][t.y])+tOri,vec2(f[4][t.x], f[4][t.y])+tOri}
           -- local c = color(rnd(128)+128, rnd(128)+128, rnd(128)+128)
            table.move({f[1]*s,f[2]*s,f[3]*s, f[1]*s,f[3]*s,f[4]*s}, 1, 6, #verts+1, verts) --triangulate
            table.move({tc[1],tc[2],tc[3], tc[1],tc[3],tc[4]}, 1, 6, #texC+1, texC)
            table.move({n,n,n,n,n,n},  1, 6, #norms+1, norms)
            table.move({c,c,c,c,c,c},  1, 6, #cols+1, cols)        
            return --end recursion
        end
        --else, do some more subdividing
        local mid = {}
        for i = 1, 4 do --4 mid points
            local j = (i % 4) + 1
            mid[i] = (f[i] + f[j]) * 0.5
        end
        local cent = (f[1] + f[2] + f[3] + f[4]) * 0.25 --centre point
        for i = 1, 4 do --4 sub-faces
            local j = (i % 4) + 1
            subdivide ({f[j], mid[j], cent, mid[i]}, depth - 1, n, c, t)        
        end    
    end
    --start subdivision

    for i = 1,6 do --6 faces. 
        --establish norm, color, and axis of texCoords for each face
        local norm = (faces[i][2]-faces[i][1]):cross(faces[i][3]-faces[i][1])
        local col = color(rnd(100)+155, rnd(100)+155, rnd(100)+155) --color(rnd(255), rnd(255), rnd(255))
        local plane = (faces[i][3]-origin)-(faces[i][1]-origin) --measure diagonal
        local tc = {x="x",y="y"}
        if plane.x==0 then tc.x="z" --if no x dimension...
        elseif plane.y==0 then tc.y="z" --or no y dimension, then remap texCoord onto Z
        end
        subdivide(faces[i], depth, norm, col, tc)
    end

    print ("recursions:", depth, "verts:", #verts) -- = 4 corners ^ depth * 6 faces * 6 tri points
    return verts, norms, cols, texC
end
