-- Cube Deform

local tArray = {{x=0,y=0, mm = matrix(), id = 0},{x=0,y=0, mm = matrix(),id=0}} --coords and matrices for 2 bones/ touch points

function setup()
    m = mesh() 
    m.texture = readImage("Cargo Bot:Game Area")
    m:setColors(color(255))
    m.vertices, m.normals, m.colors, m.texCoords = cube(5, 4) 
    m.shader = shader(Deform3.vert, Deform3.frag)
    m.shader.ambient = 0.4
    m.shader.lightColor = color(223, 216, 145, 255)
    m.shader.light = vec4(10,5,15,1)
    cam = {pos = vec3(5,-10,10)}
    centre = vec2(WIDTH, HEIGHT)/2
    print("Drag on the left and right sides of the screen to squeeze out the sponge!")

end

function draw() 
    background(40, 40, 50)
    perspective()
    camera(cam.pos.x, cam.pos.y, cam.pos.z,0,0,0)

    for i,v in ipairs(tArray) do
        if v.id == 0 then
            v.x = v.x *  0.97 --damping/ return sponge to form
            v.y = v.y *  0.97
        end
        pushMatrix()
        translate(v.x*0.02,v.y*0.02,0)
        rotate(v.x, 0,1,0)
        rotate(-v.y, 1,0,0)
        v.mm = modelMatrix()
        popMatrix()
    end

    m.shader.modelMatrix1 = tArray[1].mm
    m.shader.modelMatrix2 = tArray[2].mm --load matrices into shader
    --nb draw at the identity matrix
    m.shader.eye = cam.pos
    m:draw()
end

local sc = 0.02
function touched(t)
    if t.state == BEGAN then 
        if t.x<centre.x then --bone 1 on the left
            tArray[1].id = t.id
        else
           tArray[2].id = t.id -- bone 2 on the right       
        end
    else
        for i,v in ipairs(tArray) do
            if t.id == v.id then  --find out which side this touch originated on
                v.y = v.y + t.deltaY * 0.3
                v.x = v.x + t.deltaX * 0.3
                if t.state == ENDED then v.id = 0 end 
                --[[
                if i==1 then --only right-side touches influence lighting
                    m.shader.light = vec4((t.x - centre.x)*sc, (t.y-centre.y)*sc, 7, 1)
                end
                  ]]
            end
        end      
    end

end

Deform3={
vert = [[
const float size = 2.5;
uniform mat4 modelViewProjection;
uniform mat4 modelMatrix1; //bone1
uniform mat4 modelMatrix2; //bone2

attribute vec4 position;
attribute vec4 color;
attribute vec3 normal;
attribute vec2 texCoord;

varying lowp vec4 vNormal;
varying lowp vec4 vPosition;
varying lowp vec4 vColor;
varying highp vec2 vTexCoord;

void main()
{
    float bl = smoothstep(-size, size, position.x); 
    mat4 mm = modelMatrix1 * (1.-bl) + modelMatrix2 * bl;
    vPosition = mm * position; 
    vNormal = normalize(mm * vec4( normal, 0.0 )); 

    vColor = color;
    vTexCoord = texCoord;
    gl_Position = modelViewProjection * vPosition; 
}

]],

frag = [[

precision highp float;

uniform lowp sampler2D texture;
uniform float ambient; // --strength of ambient light 0-1
uniform vec4 light; //--directional light direction (x,y,z,0)
uniform vec4 lightColor; //--directional light colour
uniform vec4 eye; // -- position of camera (x,y,z,1)

varying lowp vec4 vNormal;
varying lowp vec4 vPosition;
varying lowp vec4 vColor;
varying highp vec2 vTexCoord;

void main()
{
    lowp vec4 pixel= texture2D( texture, vec2( fract(vTexCoord.x), fract(vTexCoord.y) ) ) * vColor; 
    lowp vec4 ambientLight = pixel * ambient;
    lowp vec4 norm = normalize(vNormal);
    lowp vec4 lightDirection = normalize(light - vPosition * light.w);
    lowp vec4 diffuse = pixel * lightColor * max( 0.0, dot( norm, lightDirection ));

    //specular blinn-phong
    vec4 cameraDirection = normalize( eye - vPosition );
    vec4 halfAngle = normalize( cameraDirection + lightDirection );
    float spec = pow( max( 0.0, dot( norm, halfAngle)), 8. );//last number is specularPower, higher number = smaller highlight
    lowp vec4 specular = lightColor  * spec * 64. ;// add optional shininess at end here

    vec4 totalColor = ambientLight + diffuse + specular;
    totalColor.a=vColor.a;
    gl_FragColor=totalColor;
}

]]}

