local WorkerManager = require('workers')
local webview = require('webview')
local base64 = require("base64")

local b64 = base64.b64

-- Class declarations
local JSParallelFunction = class()
local JSParallelResult = class()
local JSParallelInstance = class()

local POOL_SIZE_INITIAL = 4
local POOL_SIZE_MINIMUM = 2

-- Create JS environment & channel manager
local wv = webview()
local wm = WorkerManager(6767, wv)

local workerPool = {}
local function initThreadPool(num)
	for i=1,num do
		-- Add new worker to pool
		table.insert(workerPool, wm:newWorker())
	end
end
initThreadPool(POOL_SIZE_INITIAL)

local function getWorker()
	-- Get from workerPool
	local w = table.remove(workerPool)
	
	-- Add new worker to the pool
	-- TODO: This needs to be nonblocking
	if #workerPool < POOL_SIZE_MINIMUM then
		table.insert(workerPool, wm:newWorker())
	end
	
	return w
end

function JSParallelInstance:init(source)
	-- Get a worker instance
	self._worker = getWorker()
	
	source = string.format([[
		%s
		
		// TODO: add check for user defined 'kill' function
		
		while (true) {
			const invocation = await codea.recv();
			
			const fn = eval(invocation.fn);
			const result = fn(...invocation.args);
			
			if ((typeof result) === "object" && result.constructor.name == "Promise") {
				result.then((val)=>{
					codea.send({
						data: val,
						id: invocation.id
					});
				})
			}
			else
			{
				codea.send({
					data: result,
					id: invocation.id
				});
			}
		}
	]], source);
	
	-- Send the code
	self._worker:send({
		code = source,
		args = {}
	});
	
	-- Each call is assigned an ID so we can separate results
	local callId = 1
	
	setmetatable(self, {
		__index = function(t, k)
			rawset(t, k, function(...)
				self._worker:send({
					fn = k,
					args = {...},
					id = callId
				});
				
				-- Create a new receiver object for this call
				local receiver = self._worker:newReceiver(callId)
				
				-- Increment callId
				callId = callId + 1
				
				return receiver
			end)
			return t[k]
		end
	})
end

local exports = {}

exports.instance = function(source)
	return JSParallelInstance(source)
end

-- Add automated update function
exports.updatePerFrameLimit = 32
local _tweenup = tween.update
tween.update = function(...)
	_tweenup(...)
	wm:update(limit or exports.updatePerFrameLimit)
end

-- Set global
JS = exports