define(function(){
	
	function b64(v) {
		if (typeof v == "string") {
			return btoa(v)
		}
		if (v instanceof Uint8Array) {
			return btoa(String.fromCharCode.apply(null, v))
		}
		if (v instanceof Array) {
			const arr = new Array();
			for (var i = 0; i < v.length; i++) {
				arr[i] = b64(v[i]);
			}
			return arr;
		}
		if (v instanceof Object) {
			const o = new Object();
			for (k in v) {
				o[k] = b64(v[k]);
			}
			return o;
		}
		return v;
	}
	
	function unb64(v) {
		if (typeof v == "string") {
			return atob(v);
		}
		if (v instanceof Array) {
			const arr = new Array();
			for (var i = 0; i < v.length; i++) {
				arr[i] = unb64(v[i]);
			}
			return arr;
		}
		if (v instanceof Object) {
			const obj = new Object();
			for (k in v) {
				obj[k] = unb64(v[k]);
			}
			return obj;
		}
		return v;
	}
	
	class Channel {
		constructor(id, manager) {
			this.id = id;
			this.manager = manager;
		}
		
		send(msg) {
			this.manager.send(this.id, msg);
		}
		
		sendRaw(msg) {
			this.manager.sendRaw(msg);
		}
		
		recv() {
			return this.manager.recv(this.id);
		}
	}
	
	class ChannelManager {
		constructor(websocket) {
			this.ws = websocket;
		}
			
		send(channel, msg) {
			// Ensure any strings or lua strings in the msg are encoded to base64.
			const b64msg = b64(msg);
			
			let payload = {
				channel: channel,
				data: b64msg
			};
			
			payload = JSON.stringify(payload);
			
			this.ws.send(payload);
		}
			
		sendRaw(msg) {
			this.ws.send(msg);
		}
		
		recv(channel) {
			return new Promise((resolve)=>{
				// Check message queue first
				if (this.messages[channel].length > 0) {
					resolve(this.messages[channel].shift());
					return;
				}
				
				// Add our receiver
				this.messages.receivers[channel] = resolve;
			});
		}
	}
	
	return ChannelManager;
});