local WebView = class()
function WebView:init()
	-- Create the WebView config
	local config = objc.WKWebViewConfiguration()
	
	-- Ensure we can access local files
	config.preferences:setValue_forKey_("TRUE", "allowFileAccessFromFileURLs")

	-- Create the WKWebView
	self.view = objc.WKWebView:alloc()
	self.view:initWithFrame_configuration_(objc.viewer.view.bounds, config)
	
	self.view:loadFileURL_allowingReadAccessToURL_(
		objc.NSURL:fileURLWithPath_(asset.JS.web.index.path),
		objc.NSURL:fileURLWithPath_(asset.JS.web.path))
		
	-- Wait for the view to load
	while self.view.isLoading do end
end

function WebView:exec(code, args)
	self.view:callAsyncJavaScript_arguments_inFrame_inContentWorld_completionHandler_(
		code,
		args or {},
		nil,
		objc.WKContentWorld.pageWorld,
		nil
	)
end

return WebView