local socket = require("socket")

-- Delay so the JS lib is loaded first.
-- (this isn't required when used as a dependency)
tween.delay(0.1, function()

local js = JS([[
	function accumulate(n) {
		var acc = 0;
		for (var i = 1; i <= n; i++) {
			acc += i;
		}
		return acc;
	}
]])

--  Run our simple comparison case
local TEST_N = 10000000
    
-- Measure time of js function
ts = socket.gettime()
local result = js.accumulate(TEST_N):waitForResult()
te = socket.gettime()
print("Took:" .. (te - ts))

print("Running again without blocking...")
js.accumulate(TEST_N):next(function(result)
    print("Received async result! " .. result)
end)
    
function draw()
    print("draw")
    background(30, 100, 30)
end
    
end)
