local Impl = {
	config = {
		projectName = "JS",
		
		workerPoolInitial = 4,
		workerPoolMinimum = 2,
		
		connectionPort = 6767
	},
	auto = {}
}

local Instance = class()
function Instance:init(source)
	self.worker = Impl.auto.getWorker()
	
	source = source or ""
	assert(type(source) == "string")
	
	source = string.format([[
		%s
		
		// TODO: add check for user defined 'kill' function
		
		while (true) {
			const invocation = await codea.recv();
			
			const fn = eval(invocation.fn);
			const result = fn(...invocation.args);
			
			if ((typeof result) === "object" && result.constructor.name == "Promise") {
				result.then((val)=>{
					codea.send({
						data: val,
						id: invocation.id
					});
				})
			}
			else
			{
				codea.send({
					data: result,
					id: invocation.id
				});
			}
		}
	]], source);
	
	-- Send the code
	self.worker:send({
		code = source,
		args = {}
	});
	
	-- Each call is assigned an ID so we can separate results
	local callId = 1
	
	setmetatable(self, {
		__index = function(t, k)
			rawset(t, k, function(...)
				self.worker:send({
					fn = k,
					args = {...},
					id = callId
				});
				
				-- Create a new receiver object for this call
				local receiver = self.worker:newReceiver(callId)
				
				-- Increment callId
				callId = callId + 1
				
				return receiver
			end)
			return t[k]
		end
	})
end

-- Export our functions
Impl.exports = {
	default = Instance,
	instance = Instance
}

return Impl