-- MoonScript

--- @module MoonScript
-- Adds support for compiling and loading MoonScript files!

-- Add ourselves as the module search path
package.path = package.path .. ";" .. asset.documents.MoonScript.path .. "/?.lua"

--- @function MoonScript (source, chunkname)
-- Compiles and loads the given MoonScript source.
-- @param source Source code string or Codea AssetKey pointing to a .moon file.
-- @param chunkname (optional) Debug chunkname to give the loaded string. Not required when loading from an AssetKey.
-- @usage -- This is how this documentation is generated!
-- MoonScript([==[
-- export setup = ->
--    -- Call straight through to AutoDoc to display
--    -- the MoonScript module documentation.
--    AutoDoc true
-- ]==], "Main")
-- @usage -- Load from an asset file
-- MoonScript(asset.Main_moon)
function MoonScript(source, chunkname)
    -- Import moonscript
    moonscript = require "moonscript.base"
    
    if type(source) == "userdata" then
        local fn, err = moonscript.loadfile(source.path)
        if fn then fn() else objc.warning(err) end
        return
    end
    
    local success, lua_code, line_table = pcall(moonscript.to_lua, source)
    if not success then
        objc.warning(lua_code, '\n')
    else
        if lua_code then
            local fn, err = load(lua_code, chunkname)
            if not fn then
                error(err)
            end
            fn()
        else
            objc.warning(line_table)
        end
    end
end
