-- 顶部的色彩选择面板
ColorPanel = class(ui.panel)

COLORS16 = {
    color(255, 255, 255, 255),  -- White
    color(192, 192, 192, 255),  -- Silver
    color(128, 128, 128, 255),
    color(0, 0, 0, 255),
    color(255, 0, 0, 255),
    color(128, 0, 0, 255),
    color(255, 255, 0, 255),
    color(128, 128, 0, 255),
    color(0, 255, 0, 255),
    color(0, 128, 0, 255),
    color(0, 255, 255, 255),
    color(0, 128, 128, 255),
    color(0, 0, 255, 255),
    color(0, 0, 128, 255),
    color(255, 0, 255, 255),
    color(128, 0, 128, 255)
}

COLORS64 = {
    color(255, 255, 255, 255),
    color(42, 190, 217, 255),
    color(193, 80, 80, 255),
    color(237, 160, 41, 255),
    color(98, 45, 173, 255),
    color(69, 96, 208, 255),
    color(179, 204, 44, 255),
    color(52, 132, 124, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193, 193, 193, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193),
    color(255, 255, 255, 255),
    color(42, 190, 217, 255),
    color(193, 80, 80, 255),
    color(237, 160, 41, 255),
    color(98, 45, 173, 255),
    color(69, 96, 208, 255),
    color(179, 204, 44, 255),
    color(52, 132, 124, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193, 193, 193, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193),
    color(255, 255, 255, 255),
    color(42, 190, 217, 255),
    color(193, 80, 80, 255),
    color(237, 160, 41, 255),
    color(98, 45, 173, 255),
    color(69, 96, 208, 255),
    color(179, 204, 44, 255),
    color(52, 132, 124, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193, 193, 193, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193),
    color(255, 255, 255, 255),
    color(42, 190, 217, 255),
    color(193, 80, 80, 255),
    color(237, 160, 41, 255),
    color(98, 45, 173, 255),
    color(69, 96, 208, 255),
    color(179, 204, 44, 255),
    color(52, 132, 124, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193, 193, 193, 255),
    color(146, 194, 77, 255),
    color(27, 27, 27, 255),
    color(117, 65, 43, 255),
    color(193),
}

function ColorPanel:init(x,y,w,h)
    -- self.panel = UI.Panel(x,y,w,h)
    -- self.panel.fill = color(12, 232, 250, 63)
    -- self.panel.cornerRadius=0
    
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    self.fill = color(12, 232, 250, 63)
    self.cornerRadius = 0
    self.pivot = vec2(1.0, 0.5)
    self.anchor = vec2(1.2, 0.5)
    self.align = {h = ui.CENTER, v = ui.RIGHT}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(249, 248, 248, 133)
    
    self.swatches = {}
    
    
    -- 增加多个色彩选择按钮
    for k,v in pairs(COLORS16) do
        self:addSwatch(v)        
    end
end

function ColorPanel:draw()
    ui.panel.update(self)
    ui.panel.draw(self)    
end


function ColorPanel:slide(anchorX, anchorY)
    local x,y = anchorX, anchorY
    -- 在靠近顶部位置显示
    tween(0.6, self.anchor, {x = x or 0.5, y = y or 0.9}, tween.easing.cubicInOut)
end

--[[
function ColorPanel:close(anchorX, anchorY)
    local x,y = anchorX, anchorY
    -- 收起到最上方，不可见
    tween(0.6, self.anchor, {x = x or 0.5, y = y or 1.2}, tween.easing.cubicInOut) 
end
--]]

function ColorPanel:addSwatch(c)
    local swatches = self.swatches
    local spacing = 10
    local rightX = 35
    
    if #swatches > 0 then
        -- 横向排列
        -- rightX = swatches[#swatches].frame.x + swatches[#swatches].frame.w + spacing
        -- 纵向排列
        rightY = swatches[#swatches].frame.y + swatches[#swatches].frame.h + spacing
    end
    
    -- local swatch = UI.Swatch(rightX, 5, 30, 30, c)    
    -- local swatch = myui.swatch(rightX, 5, 30, 30, c)    
    local swatch = myui.swatch(5, rightY, 30, 30, c)    
    
    if c == tool.toolColor then
        swatch.selected = true
    end
    
    -- swatch.action = function(s) 
    -- function swatch.action(s) 
    swatch.onPressed = function(s) 
        
        sound(SOUND_PICKUP, 41674)   
        
        for k,v in pairs(swatches) do
            v.selected = false
        end
        
        -- 在这里实际更新基础方块颜色
        s.selected = true
        tool.toolColor = s.color
        -- Color = tool.toolColor  
        
        -- 确定方块类型为 Solid
        tool.toolUnitType = "Solid"      
    end
    
    -- 做为 colorPanel 的子节点
    -- self.panel:addChild(swatch)
    -- 横向排列
    -- local container = ui.panel({x=0, y=0, w=self.frame.w, h=60})
    -- 纵向排列    
    local container = ui.panel({x=0, y=0, w=60, h=self.frame.h})
    container.fill = color(12, 232, 250, 63)
    container:addChild(swatch) 
    self:addChild(container)
    
    table.insert(swatches, swatch)
end

--[[
function ColorPanel:update()
    self.panel:update()
end

function ColorPanel:draw()
    self.panel:draw()
end
--]]

-- 使用 ui 库
myui = {}
myui.swatch = class(ui.button)

function myui.swatch:init(x,y,w,h,c)
    local x,y,w,h,c = x,y,w,h,c
    ui.button.init(self, {x=x, y=y, w=w, h=h})
    -- ui.button.init(self,params)
    self.color = c
end

function myui.swatch:draw()
    if not self.visible then return end   
    
    pushStyle()
    pushMatrix()
    translate(self.frame.x, self.frame.y)
    tint(self.color)
    ellipseMode(CORNER)
    fill(251, 105)
    
    spriteMode(CORNER)
    
    -- 取得 Solid 的外观形状
    local icon = scene.voxels.blocks:get("Solid").icon
    
    if self.selected then
        -- ellipse(0,0,self.frame.w,self.frame.h)
        sprite(icon, 0, 0, self.frame.w, self.frame.h)
    else
        -- ellipse(5,5,self.frame.w-10, self.frame.h-10)
        sprite(icon, 5, 5, self.frame.w-10, self.frame.h-10)        
    end
    
    popMatrix()
    popStyle()
end

----
