-- 仿照 Shelf 的组织形式，利用 ui 的库，写一个带图标的 EditTool 菜单类

EditTool = class(ui.panel)

function EditTool:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 220, 220, 131)
    self.loadButton = nil
    self.saveButton = nil
    
    self.pivot = vec2(0.0, 1.0)
    self.anchor = vec2(0.02, 0.92)
    -- self.size = vec2(1,1) -- 该语句会严重改变布局
    self.w = w
    self.h = h
    self.align = {h = ui.CENTER, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    ---[[ 创建用于开启整个 UnitPanel 子菜单的按钮，控制单位方块类型/颜色选择菜单的显示/隐藏
    self.hideButton = ControlButton(1,1,50,50,"hide")
    self.hideButton.button.onPressed=function(b) 
        -- 打开二级菜单，设置
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)          
        if b.selected then
            b.label.text = "show"
            editTool:slide(anchor(device.EditTool.hide))
            -- 子菜单如果处于被打开状态，则一起隐藏
            configMenu:slide(anchor(device.ConfigMenu.hide))
            mirrorMenu:slide(anchor(device.MirrorMenu.hide))
        else
            b.label.text = "hide"
            -- editTool:slide(0.02, 0.92)
            editTool:slide(anchor(device.EditTool.show))
        end
    end
    
    ---[[ 创建用于开启整个 UnitPanel 子菜单的按钮，控制单位方块类型/颜色选择菜单的显示/隐藏
    self.fitScreenButton = ControlButton(1,1,50,50,"fitSrc")
    -- self.controlButton.title.anchor = vec2(0.5,0.5)
    self.fitScreenButton.button.onPressed=function(b) 
        -- 打开二级菜单，设置
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)    
        local originZoom = {}
        if #originZoom == 0 then
            table.insert(originZoom, viewer.zoom) 
        end     
        if b.selected then
            -- 打开
            b.label.text = "fit"
            
            viewer.zoom = 50
        else
            b.label.text = "origin"
            viewer.zoom = 30
        end
    end  
    
    
    ---[[ 设置顶部控制按钮的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.hideButton.panel.pivot = vec2(0.0, 1.0)
    self.hideButton.panel.anchor = vec2(0.02, 0.99)
    self.hideButton.panel.align = {h=ui.CENTER, v=ui.TOP}
    
    -- 设置顶部控制按钮的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.fitScreenButton.panel.pivot = vec2(0.0, 1.0)
    self.fitScreenButton.panel.anchor = vec2(0.08, 0.99)
    self.fitScreenButton.panel.align = {h=ui.CENTER, v=ui.TOP}
    --]]
    
    ---[[
    self:makeSection("history", 
    {
        imageButton(0, 500, 40, 40, "🔙", function(b) undo() end),
        imageButton(50, 500, 40, 40, "🔜", function(b) redo() end)
    })  
    
    self:makeSection("Mode", 
    {
        self:makeToolButton(0, 450, 40, 40, "add", TOOL_ADD),
        self:makeToolButton(50, 450, 40, 40, "rep", TOOL_REPLACE),
        self:makeToolButton(0, 400, 40, 40, "del", TOOL_ERASE),  
        self:makeToolButton(50, 400, 40, 40, "get", TOOL_GET),  
    })  
    
    self:makeSection("shape", 
    {
        self:makeToolTypeButton(0, 350, 40, 40, "box", TOOL_TYPE_BOX),   
        self:makeToolTypeButton(50, 350, 40, 40, "line", TOOL_TYPE_LINE),
        self:makeToolTypeButton(0, 300, 40, 40, "point", TOOL_TYPE_POINT)
        
    }) 
    
    self:makeSection("setup", 
    {
        ui.button({x=50, y=300, w=40, h=40, text="⚙️", 
            normalBg = asset.builtin.UI.Blue_Button11,
            highlightedBg = asset.builtin.UI.Blue_Button10,
            selectedBg=asset.builtin.UI.Blue_Box_Tick,
            onPressed=function(b) 
                -- 打开二级菜单，设置
                b.selected = not b.selected
                sound(SOUND_PICKUP, 41674)          
                if b.selected then
                    configMenu:slide(anchor(device.ConfigMenu.show))
                    
                else
                    configMenu:slide(anchor(device.ConfigMenu.hide))
                end
            end})   
    })
    
    self:makeSection("Models",
    {
        imageButton(0,250,40,40,"save", function(b)
            sound(SOUND_PICKUP, 41674)   
            --[[
            b.selected = not b.selected            
            if b.selected then
                modelMenu:open(0.05, 0.96)                
            else
                modelMenu:close(-0.4, 0.96)
                if myui then 
                    myui:endEditing()
                end
            end       
            --]]
            b.selected = not b.selected            
            if b.selected then
                -- 打开 save 保存子菜单
                modelMenu:slide(anchor(device.ModelMenuSave.show))                
                -- 新建文本框，用来输入待保存的模型名称
                myui = ObjcTextBox(120, 290, 150, 30)  
                -- print(typedText)  
            else
                if myui then 
                    -- 取消退出
                    myui:cancelEditing()
                end       
                
                -- 关闭本菜单退出
                modelMenu:slide(anchor(device.ModelMenu.hide))
            end        
        end),
        
        imageButton(50,250,40,40,"load", function(b)
            b.selected = not b.selected
            
            if not b.selected  then
                b.label.text = "load"
                -- 先关闭底部网格显示
                grids.bottom.enabled = true
            else
                b.label.text = "close"
                -- 先关闭底部网格显示
                grids.bottom.enabled = false
                grids.left.enabled = false
                grids.front.enabled = false
            end
            
            sound(SOUND_PICKUP, 41674)  
            
            -- 打开/关闭模型清单列表面板
            -- print("itemPanel.files", #itemPanel.files)
            itemPanel:showInventory()
        end)
    })    
    
    --]]    
end

function EditTool:draw()  
    ui.panel.update(self) 
    ui.panel.draw(self)
    
    -- 2个独立布局的按钮，不受 self.panel 布局参数的影响    
    self.hideButton:draw()
    self.fitScreenButton:draw()
end

-- 显示/隐藏菜单，使用不同的参数 (-0.4, 0.92)/(0.02, 0.92)
function EditTool:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.09, y = y or 1.0}, tween.easing.cubicInOut)
end

--[[
function EditTool:close(x,y)
    tween(0.6, self.anchor, {x=x or 0.09, y = y or 0.1}, tween.easing.cubicInOut) 
end
--]]

function EditTool:makeSection(name, items)
    -- 把标签加入 shelf 自身的孩子节点
    -- self:addChild(ui.label({x=5,y=0,w=75,h=20,text=name,alignment=LEFT}))
    
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=40})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 设定 panel 的布局
    -- container:layoutHorizontal(5, true)
    -- container.fill = color(31, 222, 10)
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

function EditTool:makeToolButton(x,y,w,h, name, mode)
    -- 创建一个新按钮
    -- local toolButton = ui.button(0, 0, 75, 30, name)    
    local toolButton = ui.button({x=x, y=y, w=w, h=h, text=name,
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        cornerRadius = 0,
    })    
    
    -- 根据当前的 tool.toolMode 同步更新本按钮状态
    if mode == tool.toolMode then
        toolButton.selected = true
    end    
    
    -- 定义按钮行为
    toolButton.onPressed = function(b) 
        -- 同类按钮互斥，点击本按钮时，其他同类按钮全部设为 false
        for k,v in pairs(b.parent.children) do
            if v ~= toolButton then
                v.selected = false
            end
        end
        
        -- 本按钮点击后翻转状态
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)          
        
        -- 如果本按钮选择状态为 true
        if b.selected then
            tool.toolMode = mode
            -- print("[add rep del get] mode:", tool.toolMode)
        else
            tool.toolMode = nil
        end
    end
    
    return toolButton
end

function EditTool:makeToolTypeButton(x,y,w,h,name, mode)
    local toolButton = ui.button({x=x, y=y, w=w, h=h, text=name,
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        align = {h = ui.CENTER, v = ui.TOP}
    })        
    
    if mode == tool.toolType then
        toolButton.selected = true
    end    
    
    toolButton.onPressed = function(b) 
        -- 同类按钮互斥
        for k,v in pairs(b.parent.children) do
            v.selected = false
        end
        
        sound(SOUND_PICKUP, 41674)          
        b.selected = true
        tool.toolType = mode
        -- print("[ box line point ] mode:", tool.toolType)
        
        -- 如果选择了 point 类型，则打开 mirror 菜单
        if mode == TOOL_TYPE_POINT then
            if b.selected then
                mirrorMenu:slide(anchor(device.MirrorMenu.show))
            end
        else
            mirrorMenu:slide(anchor(device.MirrorMenu.hide))
        end
    end
    
    return toolButton
end


-- 封装一个图像按钮
function imageButton(x,y,w,h,t, onPressed)
    local button = ui.button
    {
        x=x,
        y=y,
        w=w,
        h=h,
        opaque=false,
        text = t or "UI你好",
        fontSize = 16,
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        normalFill = color(248),
        -- align = {h = UI.CENTER, v = UI.CENTER},
        align = {h = ui.CENTER, v = ui.CENTER},
        inset = 10
    }
    
    button.onPressed = onPressed or function(b)
        -- print("bbb")
    end
    
    return button
end

----
