-- 一些辅助函数的集合
-- Using UberGoober's undo/redo code, voxel models and the new block library.


redoList = {}

-- Restore the previous snapshot (i.e. undo)
function undo()
    sound(SOUND_PICKUP, 41674)          
    if #snapshots > 1 then
        table.insert(redoList, snapshots[#snapshots])
        table.remove(snapshots, #snapshots)
        -- 加载前一个内存快照
        volume:loadSnapshot(snapshots[#snapshots])
    end
end

-- redo the last 
function redo()
    sound(SOUND_PICKUP, 41674)          
    if #redoList >=1 then
        -- 加载表里最后加入的一个快照
        -- volume:loadSnapshot(redoList[#redoList])
        table.insert(snapshots, redoList[#redoList])
        table.remove(redoList, #redoList)
        volume:loadSnapshot(snapshots[#snapshots])
    end    
end

-- Save a snapshot of the current voxel volume (for editing and undo)
function saveSnapshot()
    table.insert(snapshots, volume:saveSnapshot())      
end

--[[undo
function Snapshotter:undo()
    local spShots = self.snapshots
    if #spShots > 1 then
        table.insert(spShots.redoQueue, spShots[#spShots])
        table.remove(spShots, #spShots)
        self.volume:loadSnapshot(spShots[#spShots])
    end
end

--redo
function Snapshotter:redo()
    local spShots = self.snapshots
    local redoQueue = spShots.redoQueue
    if #redoQueue >= 1 then
        table.insert(spShots, redoQueue[#redoQueue])
        table.remove(redoQueue, #redoQueue)
        self.volume:loadSnapshot(spShots[#spShots])
    end
    redoQueue.emptyOnNextSnapshot = true
end
--]]

-- Helper function for voxel raycasts
function raycast(x,y, sides)
    local origin, dir = scene.camera:get(craft.camera):screenToRay(vec2(x, y))
    
    local blockID = nil
    local blockCoord = nil
    local blockFace = nil
    
    -- The raycast function will go through all voxels in a line starting at a given origin
    -- heading in the specified direction. The traversed voxels are passed to a callback
    -- function which is given the coordinate, id and surface normal (face).
    -- Once true is returned, the raycast will stop
    volume:raycast(origin, dir, 128, function(coord, id, face)
        if id and id ~= 0 then
            blockID = id
            blockCoord = coord
            blockFace = face
            return true
        elseif id == nil then
            
            if coord.x >= -1 and coord.x <= sx and 
            coord.y >= -1 and coord.y <= sy and
            coord.z >= -1 and coord.z <= sz then
                
                for k,v in pairs(grids) do
                    if v.enabled and v:isVisible() then
                        local d = math.abs(v.normal:dot(coord + face - v.origin))
                        if d == 0 then
                            blockID = 0
                            blockCoord = coord
                            blockFace = face  
                            return true   
                        end
                    end
                end
            end
            
        end
        return false
    end)
    
    return blockCoord, blockID, blockFace
end


-- Draw a 256*256*256 box, from vec3(0,0,0) to vec3(255,255,255), it is the block type range.
function blockRange()
    scene.debug:line(vec3(0, 0, 0),vec3(255, 0, 0),color(47, 239, 5))
    scene.debug:line(vec3(0,0,0),vec3(0, 255, 0),color(239, 5, 5))
    scene.debug:line(vec3(0,0,0),vec3(0, 0, 255),color(5, 41, 239))
    
    scene.debug:line(vec3(255,255,255),vec3(0, 255, 255),color(239, 91, 5))
    scene.debug:line(vec3(255,255,255),vec3(255, 0, 255),color(214, 5, 239))
    scene.debug:line(vec3(255,255,255),vec3(255, 255, 0),color(5, 238, 239))
    
    scene.debug:line(vec3(255, 255, 0),vec3(255, 0, 0),color(239, 234, 5))
    scene.debug:line(vec3(255,0,255),vec3(255, 0, 0),color(239, 5, 5))
    scene.debug:line(vec3(0,0,255),vec3(255, 0, 255),color(128, 5, 239))
    
    scene.debug:line(vec3(0,255,255),vec3(0, 0, 255),color(239, 5, 172))
    scene.debug:line(vec3(0,255,255),vec3(0, 255, 0),color(185, 239, 5))
    scene.debug:line(vec3(255,255,0),vec3(0, 255, 0),color(5, 238, 239))
end

-- 生成色阶表，共64种
function generateColor()
    local r,g,b = 0,0,0
    local c = color(r,g,b)
    local ct = {}
    for r = 0,255,64 do
        for g = 0,255,64 do
            for b = 0,255,64 do
                c = color(r,g,b,255)
                table.insert(ct,c)
            end
        end
    end
    return ct
end
----
