-- 保存/加载模型子菜单

ModelMenu = class(ui.panel)

function ModelMenu:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 220, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.anchor = vec2(-0.4, 0.96)
    self.pivot = vec2(0.0, 1.0)
    self.w = w
    self.h = h
    self.align = {h = ui.CENTER, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    self:makeSection("Models",
    {
        imageButton(100,200,40,30,"ok", function(b)
            -- b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            
            -- myui = ObjcTextBox(0, 100, 200, 30)  
            -- print(typedText)
            if myui then 
                -- 写入保存模型，退出
                myui:endEditing()
            end
            self:slide(anchor(device.ModelMenu.hide))
        end),
        
        imageButton(150,200,40,30,"cancel", function(b)
            --[[
            b.selected = not b.selected
            if not b.selected  then
                b.label.text = "cancel"
            else
                b.label.text = "cancel"
            end
            --]]
            sound(SOUND_PICKUP, 41674)   
            
            if myui then 
                -- 取消退出
                myui:cancelEditing()
            end       
            
            -- 关闭本菜单退出
            self:slide(anchor(device.ModelMenu.hide))
        end)
    })    
    
    --]]    
end

function ModelMenu:draw()  
    ui.panel.update(self) 
    ui.panel.draw(self) 
end

function ModelMenu:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end
--[[
function ModelMenu:close(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 0.1}, tween.easing.cubicInOut) 
end
--]]

function ModelMenu:makeSection(name, items)
    -- 把标签加入 shelf 自身的孩子节点
    -- self:addChild(ui.label({x=5,y=0,w=75,h=20,text=name,alignment=LEFT}))
    
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 设定 panel 的布局
    -- container:layoutHorizontal(5, true)
    -- container.fill = color(31, 222, 10)
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end   

----
