-- 设置子菜单：操作区网格设置，模型框线设置，模型尺寸设置

ConfigMenu = class(ui.panel)

function ConfigMenu:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 220, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.anchor = vec2(-0.2, 0.92)
    self.pivot = vec2(0.0, 1.0)
    self.w = w
    self.h = h
    self.align = {h = ui.CENTER, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    self:makeSection("grid",
    {
        imageButton(0,150,35,30,"sides", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)       
            -- 显示周围4面网格
            grids.left.enabled = b.selected
            grids.right.enabled = b.selected 
            grids.front.enabled = b.selected
            grids.back.enabled = b.selected                     
        end),
        
        imageButton(50,150,35,30,"top", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)     
            -- 显示顶部网格            
            grids.top.enabled = b.selected
        end),
        
        imageButton(100,150,35,30,"down", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)      
            -- 显示底部网格
            grids.bottom.enabled = b.selected
        end)
    })
    
    self:makeSection("options",
    {
        imageButton(150,150,35,30,"outline", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            volume.model:getMaterial().showOutline = b.selected
        end)
    })
    
    self:makeSection("Size",
    {
        -- 生成 size 调整菜单
        self:makeRangeButton(0,100,35,30),
    }) 
    
    self:makeSection("ShowWholeRange",
    {
        -- 显示全部可操作区域: 256*256*256
        imageButton(0,-50,35,30,"range", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            showRange = not showRange
        end),
        
        -- 为方便理解，把被切分移动部分的原位置填充为: Water/Empty
        imageButton(50,-50,35,30,"split", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            showSplit = not showSplit
        end),
        
        -- 是否把模型保存到 Documents 目录下(缺省保存在本项目的 models 目录下)，方便其它程序使用
        imageButton(100,-50,35,30,"share", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            shareModel = not shareModel
        end),
        
        -- 是否加载预置模型(sampleModel)，该目录内模型不可修改，缺省加载本项目的 models 目录下的模型，
        imageButton(150,-50,35,30,"sample", function(b)
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)          
            sampleModel = not sampleModel
        end),
    })               
end 

-- 用于调整 x，y，z 尺寸的按钮
function ConfigMenu:makeRangeButton(x,y,w,h)
    local x,y,w,h = x,y,w,h
    
    local xTitle = ui.button({x=x, y=y, w=w,h=h,text="X :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local yTitle = ui.button({x=x, y=y-50, w=w,h=h,text="Y :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local zTitle = ui.button({x=x, y=y-100, w=w,h=h,text="Z :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    
    -- 实时显示模型长宽高数据
    self.xMiddle = ui.label({x=x+100, y=y, w=w, h=h, text=SizeX, alignment=CENTER})
    self.yMiddle = ui.label({x=x+100, y=y-50, w=w, h=h, text=SizeY, alignment=CENTER})
    self.zMiddle = ui.label({x=x+100, y=y-100, w=w, h=h, text=SizeZ, alignment=CENTER})
    
    local xMiddle,yMiddle,zMiddle = self.xMiddle, self.yMiddle, self.zMiddle
    
    local xLeft =ui.button({x=x+50, y=y, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)          
            if SizeX>1 then
                SizeX = SizeX-1
            end
            xMiddle.text = SizeX
            shouldResize = true
        end})
    
    local xRight = ui.button({x=x+150, y=y, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)          
            SizeX = SizeX+1
            xMiddle.text = SizeX
            shouldResize = true
        end})
    
    local yLeft =ui.button({x=x+50, y=y-50, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)   
            if SizeY>1 then
                SizeY = SizeY-1
            end
            yMiddle.text = SizeY
            shouldResize = true
        end})
    
    local yRight = ui.button({x=x+150, y=y-50, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)          
            SizeY = SizeY+1
            yMiddle.text = SizeY
            shouldResize = true
        end})
    
    local zLeft =ui.button({x=x+50, y=y-100, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)          
            if SizeZ>1 then
                SizeZ = SizeZ-1
            end
            zMiddle.text = SizeZ
            shouldResize = true
        end})
    
    local zRight = ui.button({x=x+150, y=y-100, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            -- mirror.z = b.selected
            sound(SOUND_PICKUP, 41674)          
            SizeZ = SizeZ+1
            zMiddle.text = SizeZ
            shouldResize = true
        end})
    
    return xTitle,yTitle,zTitle,xLeft,xMiddle,xRight,yLeft,yMiddle,yRight,zLeft,zMiddle,zRight
end

function ConfigMenu:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end

function ConfigMenu:makeSection(name, items)
    -- 把标签加入 shelf 自身的孩子节点
    -- self:addChild(ui.label({x=5,y=0,w=75,h=20,text=name,alignment=LEFT}))
    
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 设定 panel 的布局
    -- container:layoutHorizontal(5, true)
    -- container.fill = color(31, 222, 10)
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

--[[ 子类如何显式调用父类的 update() ?
function ConfigMenu:update()
    ui.panel.update(self)
    
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    if self.xMiddle then
        self.xMiddle.text = SizeX
    end
    
    if self.yMiddle then
        self.yMiddle.text = SizeY
    end
    
    if self.zMiddle then
        self.zMiddle.text = SizeZ
    end
end
--]]

function ConfigMenu:draw() 
    -- 子类如何显式调用父类的 update() ? 
    ui.panel.update(self) 
    
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    if self.xMiddle then
        self.xMiddle.text = SizeX
    end
    
    if self.yMiddle then
        self.yMiddle.text = SizeY
    end
    
    if self.zMiddle then
        self.zMiddle.text = SizeZ
    end
    
    ui.panel.draw(self) 
end

----
