-- 物品清单面板，通过 load 打开面板

ItemPanel = class()

function ItemPanel:init()
    self.isInventoryOpen = false
    self.inventory = nil
    self.hotbar = nil
    self.slot = nil
    self.tab = nil
    self.tabs = {}
    self.tabSlot = nil
    self.tabIndex = 1
    -- 设置模型文件加载路径：本项目文件夹内 models 目录下
    self.files = asset.models.all
    -- self.files = asset.documents.all
    self.iconPath = asset.volumeIcons
    self.volumes = {}
    self.volumesSample = {}
    
    -- 模型清单主面板 self.inventory 的行，列，单位尺寸大小
    self.mRows = 4
    self.mCols = 5
    self.mGSize = 128
    
    -- 面板的长度，宽度
    -- local w,h =
    -- self.gridCols * self.gridSize + self.border * 2 + (self.gridCols-1) * self.spacing,
    -- self.gridRows * self.gridSize + self.border * 2 + (self.gridRows-1) * self.spacing
    local panelW, panelH =
    self.mCols * self.mGSize + 5*2 + (self.mCols-1)*5, 
    self.mRows * self.mGSize + 5*2 + (self.mRows-1)*5 + 5*2+64+48
    
    -- 新建一个背景 panel，可作为本类中所有控件的父节点
    self.panel = ui.panel
    {
        pivot = vec2(0.5, 1.0),
        anchor = vec2(0.5, 2.0),
        w = panelW,
        h = panelH,
        align = {h = ui.CENTER, v = ui.TOP},
        -- bg = "UI:Grey Panel",
        bg = asset.builtin.UI.Grey_Panel,
        fill = color(0, 25),
        inset = 10,
    }
    
    -- 取得指定目录下的所有 Voxel 模型，将其存入 self.volumes 表中，为每个模型生成预览图像
    -- self.volumesModels = self:getAllVolumes(asset.documents.MyAmuseModels.all)
    self.volumesModels = self:getAllVolumes(asset.models.all)
    
    -- 预置模型保存在项目内部目录 asset.sampleModels 中
    self.volumesSample = self:getAllVolumes(asset.sampleModels.all)
    
    if sampleModel then
        self.volumes = self.volumesSample
    else
        self.volumes = self.volumesModels
    end
    
    
    self:calcParams()
    
    self:createInvPanel()
    
    
    --[[ 设置快捷条第一个槽位
    local firstTabSlot = self.tab:getSlot(1)
    firstTabSlot.button.label.anchor = vec2(0.5, 0.5)
    firstTabSlot.button.label.fontSize = 30
    firstTabSlot.button.label.text = self.tabIndex
    firstTabSlot = self.tab:getSelected()
    firstTabSlot.button.onPressed = function(b) 
        self.tab:setSelected(firstTabSlot)
    end
    --]]
    
    -- self.tab:load(asset.."ItemPanelTab.txt")
    
    --[[ 创建下方快捷条
    self.hotbar = Inventory(1,8, 32,5,5, function() end)
    self.hotbar.itemCallback = function(inventory, slot)
        inventory:setSelected(slot)
        self.slot = slot
        sound(SOUND_PICKUP, 41674)   
        
        self.inventory = self.tabs[self.tabIndex] 
        
        -- 回调函数：点击某槽位，则根据该槽位对应索引从 volumes 中选择模型，加载到当前编辑区
        -- self:loadVolumeModel(volume, self.volumes[slot.index])  
        local index = slot.index + (self.tabIndex-1)*25  
        if index <= #self.volumes then
            self:loadVolumeModel(volume, self.volumes[index].volume) 
        end   
        
        sx, sy, sz = volume:size()
        SizeX,SizeY,SizeZ = sx,sy,sz
        
        -- 当有模型加载时更新 dx,dy,dz
        if splitMergePanel then
            splitMergePanel.sx = sx
            splitMergePanel.sy = sy
            splitMergePanel.sz = sz
            splitMergePanel.dx = math.floor(sx/2)-1
            splitMergePanel.dy = math.floor(sy/2)-1
            splitMergePanel.dz = math.floor(sz/2)-1
        end     
    end
    
    -- 设置快捷条的位置布局
    self.hotbar.panel.pivot = vec2(0.5, 0)
    self.hotbar.panel.anchor = vec2(0.8, 0.4)
    self.hotbar.panel.align.h = ui.CENTER
    self.hotbar.panel.align.v = ui.BOTTOM
    
    -- 设置快捷条最后一个选项
    local lastSlot = self.hotbar:getSlot(self.hotbar:slotCount())
    lastSlot.button.label.text = "模型库"
    lastSlot.button.onPressed = function(b)
        sound(SOUND_PICKUP, 41674)          
        
        self.inventory = self.tabs[self.tabIndex] 
        if self.isInventoryOpen then
            -- tween(0.6, self.inventory.panel.anchor, {y = 1.0}, tween.easing.cubicInOut)
            self.inventory:open(0.0, 1.0)
            self.isInventoryOpen = false
        else
            -- tween(0.6, self.inventory.panel.anchor, {y = 0.2}, tween.easing.cubicInOut) 
            self.inventory:close(0.0, 0.1)
            self.isInventoryOpen = true       
        end
    end
    
    -- self.hotbar:load("Project:Hotbar")
    self.hotbar:load(asset.."ItemPanelHotbar.txt")
    self.slot = self.hotbar.selected    
    self.panel:addChild(self.hotbar.panel) 
    --]]
end

function ItemPanel:calcParams()
    -- 遍历模型表 volumes，将所有的模型分成几批[1,25],[25+1,50],[50+1,75]，选择对应批次插入物品仓库中
    self.rangeUnit = self.mRows * self.mCols
    -- local min,max = {1,26,51},{25,50,75} 
    -- 模型总数为 37 时，区间分为：min,max = {1,26},{25,37} 
    self.min, self.max = {},{}  
    
    self.total = #self.volumes
    -- 计算得到整除的商 m 和余数 n
    self.m = math.floor(self.total/self.rangeUnit)
    self.n = math.fmod(self.total,self.rangeUnit)
    for i=1,self.m do
        table.insert(self.min,(i-1)*self.rangeUnit+1)
        table.insert(self.max,i*self.rangeUnit)
    end
    
    -- 若整除，余数为0，则使其为1，避免临界状态
    if self.n == 0 then self.n = self.n +1 end
    
    -- 若余数不为0，则把最后一组没有被整除的余数计算后插入
    if self.n >0 then
        table.insert(self.min, self.m*self.rangeUnit+1)
        table.insert(self.max, self.m*self.rangeUnit+self.n)
    end
end


function ItemPanel:createInvPanel()
    -- 根据 self.min 中元素个数，确定需要创建几列 tab 标签页
    local tabCol = #self.min
    
    -- 只创建一个 Inventory，每次在 self.tab 的回调函数中动态生成其图标/文字内容
    self.inventory = Inventory(self.mRows, self.mCols, self.mGSize, 5,5, function() end)
    
    -- 根据模型个数动态创建 tab 标签选项，这里只需要能选择 tab 索引并把它赋值给 self.tabIndex 就可以
    self.tab = Inventory(1, tabCol, 64, 5,10, function() end)    
    self.tab.itemCallback = function(inv, tabSlot)
        sound(SOUND_PICKUP, 41674)   
        -- 当前槽位按钮被选中时，保持选中状态，tabslot代表被选中的槽位
        inv:setSelected(tabSlot)
        
        -- 点击 tab时，用来设定 tab 标签上的文本内容和字体大小：也就是数字序号
        tabSlot.button.label.anchor = vec2(0.5, 0.5)
        tabSlot.button.label.fontSize = 30
        tabSlot.button.label.text = tabSlot.index
        
        -- 初始化 self.inventory 清单面板的显示
        self.tabIndex = tabSlot.index
        
        -- 先清除前一个 self.inventory 面板在每个槽位中的内容
        self.inventory:removeItem("")
        
        -- 动态加入当前索引区间(由 self.tabIndex 计算得到)的模型数据：图标，名称
        for volumeIndex = self.min[self.tabIndex], self.max[self.tabIndex] do
            -- print("volume index:", volumeIndex)
            local item = self.volumes[volumeIndex]
            self.inventory:addItem(item)
        end   
        
        -- 整个 inventory 只定义了一个回调函数，参数 inventory 是它自身，参数 slot 是被点击的槽位
        -- 该回调函数是每个槽位的模型按钮，点击后加载对应模型
        -- self.tabs[self.tabIndex].itemCallback = function(inventory, slot)
        self.inventory.itemCallback = function(inventory, slot)
            -- 点击本槽位按钮时，立刻选定对应模型
            inventory:setSelected(slot)
            self.slot = slot
            
            -- 获取当前 hotbar 中被选中的槽位，目前返回 nil，说明没有选中
            -- local hotbarSlot = self.hotbar:getSelected()
            -- print("hotbarSlot: ", hotbarSlot)
            -- if hotbarSlot and slot.block then
            if slot.block then
                local block = slot.block
                -- print("slot index name:",slot.index, block)
                -- print("hotbarSlot.index: ", hotbarSlot.index)
                -- inventory.title.text = string.upper( block.longName or block.name )
                -- 在整个面板最上方显示选中的槽位中保存的 block/volume 的名字
                inventory.title.text = block.name or block.longName
                -- 把 inventory 面板中某个 slot 槽位选中的 block 同步到 hotbar 中被选中的槽位上
                -- self.hotbar:setItem(hotbarSlot.index, block)    
                -- self.hotbar:save(asset.."ItemPanelHotbar.txt")
                sound(SOUND_PICKUP, 41674)   
                
                -- 回调函数：点击某槽位，则根据该槽位对应索引从 volumes 中选择模型，加载到当前编辑区
                local index = slot.index + (self.tabIndex-1) * self.rangeUnit
                -- self:loadVolumeModel(volume, self.volumes[index]) 
                -- print("self.tabIndex: ", i, index) 
                if index <= #self.volumes then
                    -- print("volume index:", index)
                    self:loadVolumeModel(volume, self.volumes[index].volume)  
                end
                
                sx, sy, sz = volume:size()
                SizeX,SizeY,SizeZ = sx,sy,sz          
                -- 当有模型加载时更新 dx,dy,dz
                if splitMergePanel then
                    splitMergePanel.sx = sx
                    splitMergePanel.sy = sy
                    splitMergePanel.sz = sz
                    splitMergePanel.dx = math.floor(sx/2)-1
                    splitMergePanel.dy = math.floor(sy/2)-1
                    splitMergePanel.dz = math.floor(sz/2)-1
                end
            end
        end
    end
    
    -- 初始化时显示所有 tab 标签页面的编号
    for k,v in pairs(self.tab.slots) do
        local slot = v
        slot.button.label.anchor = vec2(0.5, 0.5)
        slot.button.label.fontSize = 30
        slot.button.icon.img = nil
        slot.button.label.text = k
        slot.block = nil
    end
    
    
    -- 把第一个 tab 标签页面外观设置为已选中，这里只能显示，点击选择模型时无法加载，必须手动点击 tab 按钮
    local firstTabSlot = self.tab:getSlot(1)
    self.tab:setSelected(firstTabSlot)
    
    -- 初始化 self.inventory 清单面板的显示
    -- self.tabIndex = firstTabSlot.index
    -- 手动执行 self.tab 的回调函数
    self.tab:itemCallback(firstTabSlot)
    
    --[[ 先清除前一个 self.inventory 面板在每个槽位中的内容
    self.inventory:removeItem("Empty")
    
    -- 动态加入当前索引区间(由 self.tabIndex 计算得到)的模型数据：图标，名称
    for volumeIndex = self.min[self.tabIndex], self.max[self.tabIndex] do
        -- print("volume index:", volumeIndex)
        local item = self.volumes[volumeIndex]
        self.inventory:addItem(item)
    end   
    -- 手动执行 self.inventory 的回调函数，但是本回调函数定义在 tab 的回调函数中，必须先执行一遍 tab 的回调才行
    local firstInvSlot = self.inventory:getSlot(1)
    self.inventory:setSelected(firstInvSlot)
    self.inventory:itemCallback(firstInvSlot)
    --]]
    
    
    -- 统一加入 self.panel 子节点，方便布局
    self.panel:addChild(self.tab.panel) 
    self.panel:addChild(self.inventory.panel) 
    
    -- 布局方式：有三种场景需要考虑，初始化时的缺省位置，开启时位置，关闭时位置
    -- 设置各控件在 self.panel 上的布局：这里是初始化位置
    self.inventory.panel.anchor = vec2(0.5, 1.5)
    self.inventory.panel.pivot = vec2(0.5, 0.0)
    self.inventory.panel.align = {h=ui.CENTER, v=ui.TOP}
    
    -- 设置 tab 的位置布局
    self.tab.panel.anchor = vec2(0.5, 1.0)
    self.tab.panel.pivot = vec2(0.5, 1.0)
    self.tab.panel.align = {h=ui.CENTER, v=ui.TOP}
    -- self.tab.panel.bg = asset.builtin.UI.Grey_Panel
    -- self.tab.panel.fill = color(0, 26)
    self.tab.panel.inset = 10
end

function ItemPanel:getAllVolumes(volumePath)
    -- 遍历目录中所有的 voxel 模型
    local volumeTable = {}
    for k,v in pairs(volumePath) do
        if v.ext == "cvox" then 
            -- local modelImg = self:generateModelPreview(self.volumes[i].volume)
            local modelImg = self:generateModelPreview(v)
            
            -- 改造为跟block一致的表结构，可以合并代码，尽量使用 Inventory 原来的流程，减少循环
            local block = {volume=v, name=v.name, hasIcon=false, icon=modelImg}
            
            table.insert(volumeTable, block)                      
        end
    end
    return volumeTable
end

-- 向 self.volumes 中追加最新编辑保存的 volume 模型
function ItemPanel:appendItem(v)
    
    local modelImg = self:generateModelPreview(v)
    
    -- 改造为跟block一致的表结构，可以合并代码，尽量使用 Inventory 原来的流程，减少循环
    local block = {volume=v, name=v.name, hasIcon=false, icon=modelImg}
    table.insert(self.volumes, block)   
    
    local item = self.volumes[#self.volumes]
    self.inventory:addItem(item)                   
end

function ItemPanel:checkDup(name)
    for k,v in pairs(self.volumes) do
        -- print("name: ", name, v.name)
        if name == v.name then
            return true
        else
            return false
        end
    end
end

-- 显示/隐藏 (-0.4, 0.92)|.  (0.02, 0.92)/(-0.2, 0.92)
function ItemPanel:slide(x,y)
    tween(0.6, self.panel.anchor, {x=x or 0.5, y = y or 1.5}, tween.easing.cubicInOut)
end

-- 显示物品清单
function ItemPanel:showInventory()
    
    -- 在这里动态创建模型清单面板
    -- self:calcParams()
    -- self.inventory:removeItem("e")
    -- self.tab:removeItem("e")
    -- self:createInvPanel()
    
    if self.isInventoryOpen then
        -- local x,y = anchor(device.ItemPanel.show)
        -- tween(0.6, self.panel.anchor, {y = y or 1.5}, tween.easing.cubicInOut)
        self:slide(anchor(device.ItemPanel.show))
        self.tab:slide(anchor(device.ModelItemTab.show))
        self.inventory:slide(anchor(device.ModelItemInv.show))
        self.isInventoryOpen = false
    else
        -- local x,y = anchor(device.ItemPanel.hide)
        -- tween(0.6, self.panel.anchor, {y = y or 0.9}, tween.easing.cubicInOut) 
        self:slide(anchor(device.ItemPanel.hide))
        self.tab:slide(anchor(device.ModelItemTab.hide))
        self.inventory:slide(anchor(device.ModelItemInv.hide))
        self.isInventoryOpen = true       
    end
end


-- Uses the camera to generate previews of blocks before the scene starts
function ItemPanel:generateModelPreview(model)
    
    -- Try to read a cached version of the icon first
    -- local img = readImage("Project:"..block.name)
    -- local img = readImage(asset..model.name)
    local img = readImage(self.iconPath..model.name)
    
    if img then
        return img
    end
    
    local camera = scene.camera:get(craft.camera)
    local sky = scene.sky
    
    local ortho = camera.ortho
    local orthoSize = camera.orthoSize
    
    --[[ 
    pb = craft.bloomEffect()
    pb.enabled = true 
    pb.iterations = 5
    pb.threshold = 0.06
    pb.softThreshold = 1.6
    pb.intensity = 0.06
    
    camera.hdr = true
    camera.colorTextureEnabled = true
    camera.clearDepthEnabled = true
    camera.clearColorEnabled = true
    camera.depthTextureEnabled = true
    camera:addPostEffect(pb)
    --]]
    
    camera.ortho = false
    camera.orthoSize = 20.9
    camera.entity.rotation = quat.eulerAngles(35, 45, 0)
    camera.entity.position = vec3(0.5, 10.5, 0.5) - camera.entity.forward * 50
    camera.clearColorEnabled = false
    -- 将 sky 设置为 false 可以得到背景透明的预览图标
    sky.active = false
    
    -- 加载方块形体
    local volumeObj = scene:entity()
    local volume = volumeObj:add(craft.volume, 1, 1, 1)   
    volume.model:getMaterial().showOutline = true
    -- volumeObj.scale= vec3(0.1,0.1,0.1)
    
    -- 实际执行模型加载
    self:loadVolumeModel(volume, model)
    
    -- 为model拍照
    img = image(128, 128)
    setContext(img, true)
    camera:draw()
    setContext()
    
    volumeObj:destroy() 
    
    camera.ortho = ortho
    camera.orthoSize = orthoSize
    camera.clearColorEnabled = true
    sky.active = true
    
    -- saveImage(asset..model.name, img)
    saveImage(self.iconPath..model.name, img)
    return img 
end

function ItemPanel:draw()
    
    self.panel:update()
    self.panel:draw()
    
    -- 这个快捷条还没想好用途跟布局，暂时先注释掉
    -- self.hotbar:update()  
    -- self.hotbar:draw()  
end

-- 加载模型
function ItemPanel:loadVolumeModel(volume, model)
    -- 加载 volume model
    -- 加载模型，volume 使用前面代码块中定义好的
    volume:load(model)
    
    -- 获得当前加载模型的尺寸，并根据当前模型尺寸实时更新网格
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    -- 把模型中心点设为镜头中心
    viewer.target = vec3(sx/2 + 0.5, sy/2 + 0.5, sz/2 + 0.5)
    viewer.origin = viewer.target
    updateGrid()
    
    saveSnapshot()
end


