-- MenuLayoutParams
-- menu/button show/hide anchor coords

menuParams = { iPad129={}, iPad97={}, iPad79 = {}, iPhone11 = {}}

-- 适用于iPad 12.9 屏幕的菜单布局
menuParams.iPad129 = {
    -- 左上角区域菜单: show,
    EditToolHideButton = {show = vec2(0,0), hide = vec2(0,0)},
    EditTool = {show = vec2(0.02, 0.92), hide = vec2(-1.0, 0.92)},
    MirrorMenu = {show = vec2(0.02, 0.92), hide = vec2(-0.4, 0.92)},
    ConfigMenu = {show = vec2(0.02, 0.92), hide = vec2(-0.2, 0.92)},
    
    -- save/ok/cancel
    ModelMenu = {show = vec2(0,0), hide = vec2(-0.4, 0.96)},
    ModelMenuSave = {show = vec2(0.05, 0.96), hide = vec2(-0.4, 0.96)},
    -- ModelMenuLoad = {show = vec2(0.05, 0.96), hide = vec2(-0.4, 0.96)},
    
    -- 顶部区域菜单1：load 
    ItemPanel = {show = vec2(0.5, 2.0), hide = vec2(0.5,0.9)},
    ModelItemTab = {show = vec2(0.0, 2.0), hide = vec2(0.0,0.98)},
    ModelItemInv = {show = vec2(0.0, 2.0), hide = vec2(0,0)},
    ModelItemInvLabel = {show = vec2(0.5, 0.1), hide = vec2(0,0)},
    
    -- 新颜色方块面板: newColorPanel 这里提供最多颜色，会减慢加载速度
    NewColorPanel = {show = vec2(0.85, 0.75), hide = vec2(1.5, 0.75)},
    NewColorTab = {show = vec2(0.0, 0.98), hide = vec2(0.0, 0.75)},
    NewColorInv = {show = vec2(0.0, 0.0), hide = vec2(0, 0.75)},
    
    -- 右上角区域菜单：unitPanel  建筑单位
    UnitButton = {show = vec2(0.45,0.8), hide = vec2(1.4, 0.8)},  
    UnitPanel = {show = vec2(0.5,0.88), hide = vec2(0.5, 1.8)},  
    UnitInv = {show = vec2(0.5, 0), hide = vec2(0,0)},  
    UnitInvLabel = {show = vec2(0.5, 0), hide = vec2(0,0)},    
    
    -- 右上角区域菜单：2x, split
    MulReduButton = {show = vec2(0.916, 0.99), hide = vec2(0,0)},
    MulReduPanel = {show = vec2(0.7,0.85), hide = vec2(1.2, 0.85)},
    
    SplitMergeButton = {show = vec2(0.85,0.8), hide = vec2(1.4, 0.8)},
    SplitMergePanel = {show = vec2(0.85,0.8), hide = vec2(1.4, 0.8)},
    
    -- 右侧区域竖条菜单: colorPanel 这里可以提供少量颜色，提升加载速度
    ColorPanel = {show = vec2(1.6, 0.3), hide = vec2(2.0, 0.3)},
    ColorTab = {show = vec2(0.0, 1.5), hide = vec2(0,0)},
    ColorInv = {show = vec2(0.0, 1.5), hide = vec2(0,0)},
    
    -- 底部区域菜单: hotbar 归属于 UnitPanel
    UnitHotbar = {show = vec2(0.5, 0.02), hide = vec2(0,0)},
}

-- 当前设备为 iPad129
device = menuParams.iPad129

function anchor(menu)
    local x,y = menu.x, menu.y
    return x,y
end

-- 适用于iPAD 9.7 屏幕的菜单布局
menuParams.iPad97 = {
    -- todo
}

-- 适用于iPad 7.9 屏幕的菜单布局(iPADmini)
menuParams.iPad79 = {
    -- todo
}

-- 适用于iPhone11 屏幕的菜单布局
menuParams.iPhone11 = {
    -- todo
}
