-- 镜像子菜单

MirrorMenu = class(ui.panel)

function MirrorMenu:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 220, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.anchor = vec2(-0.2, 0.92)
    self.pivot = vec2(0.0, 1.0)
    self.w = w
    self.h = h
    self.align = {h = ui.CENTER, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    --]]
    self:makeSection("mirror", 
    {
        ui.button({x=0, y=200, w=35, h=30, text="X | X", 
            normalBg = asset.builtin.UI.Blue_Button11,
            highlightedBg = asset.builtin.UI.Blue_Button10,
            selectedBg=asset.builtin.UI.Blue_Box_Tick,
            onPressed=function(b) 
                b.selected = not b.selected
                sound(SOUND_PICKUP, 41674)          
                tool.mirror.x = b.selected
            end}),
        ui.button({x=50, y=200, w=35, h=30, text="Y | Y", 
            normalBg = asset.builtin.UI.Blue_Button11,
            highlightedBg = asset.builtin.UI.Blue_Button10,
            selectedBg=asset.builtin.UI.Blue_Box_Tick,
            onPressed=function(b) 
                b.selected = not b.selected
                sound(SOUND_PICKUP, 41674)          
                tool.mirror.y = b.selected
            end}),
        ui.button({x=100, y=200, w=35, h=30, text="Z | Z", 
            normalBg = asset.builtin.UI.Blue_Button11,
            highlightedBg = asset.builtin.UI.Blue_Button10,
            selectedBg=asset.builtin.UI.Blue_Box_Tick,
            onPressed=function(b) 
                b.selected = not b.selected
                sound(SOUND_PICKUP, 41674)          
                tool.mirror.z = b.selected
            end})
    })  
end

function MirrorMenu:draw()  
    ui.panel.update(self) 
    ui.panel.draw(self) 
end

-- 显示/隐藏 (-0.4, 0.92)|.  (0.02, 0.92)/(-0.2, 0.92)
function MirrorMenu:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end



function MirrorMenu:makeSection(name, items)
    -- 把标签加入 shelf 自身的孩子节点
    -- self:addChild(ui.label({x=5,y=0,w=75,h=20,text=name,alignment=LEFT}))
    
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 设定 panel 的布局
    -- container:layoutHorizontal(5, true)
    -- container.fill = color(31, 222, 10)
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

----
