-- 倍增/倍减子菜单：对模型进行倍增/倍减操作
-- 改为：移动/缩放：对模型进行移动/缩放操作
-- 效果示范：AB => AABB

---[==[
MulReduPanel = class(ui.panel)

function MulReduPanel:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 220, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.pivot = vec2(1.0, 1.0)
    self.anchor = vec2(1.2, 0.85)   -- device.MulReduPanel.hide --
    self.w = w
    self.h = h
    self.align = {h = ui.RIGHT, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    self.panel = ui.panel
    {
        pivot = vec2(1.0, 1.0),
        anchor = vec2(1.2, 0.85),
        w = w,
        h = h,
        align = {h = ui.RIGHT, v = ui.TOP},
        bg = asset.builtin.UI.Grey_Panel,
        fill = color(0, 25),
        cornerRadius = 5,
        inset = 10,
    }
    
    -- 设置切分后被切掉部分原来位置的填充类型，可使用 "Empty"，或 "Water"
    self.empty = "New Stone"
    
    self.sx, self.sy, self.sz = volume:size()
    SizeX,SizeY,SizeZ = self.sx, self.sy, self.sz
    
    -- volume 整体移动的偏移量
    self.dx = 0
    self.dy = 0
    self.dz = 0
    self.step = 1
    self.loop = false
    
    -- 设定切片之间放置的间隔，该间隔放在 volume 最右侧
    self.span = 0
    
    self.multX, self.multY, self.multZ = {}, {}, {}
    self.reduX, self.reduY, self.reduZ = {}, {}, {}
    
    ---[[ 创建控制按钮，用于打开倍增/倍减面板面板
    -- self.mulReduButton = ControlButton(1,1,50,50,"fitSrc")
    -- self.mulReduButton = ControlButton(WIDTH - 130, HEIGHT-60, 50, 50, "2x")
    self.mulReduButton = ControlButton(0,0,50,50,"2x")
    -- print("self.mulReduButton ", self.mulReduButton)
    -- self.controlButton.title.anchor = vec2(0.5,0.5)
    self.mulReduButton.button.onPressed=function(b) 
        -- 打开二级菜单，设置
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)    
        
        if b.selected then
            b.label.text = "close"
            -- mulReduPanel:slide(0.45,0.8)
            mulReduPanel:slide(anchor(device.MulReduPanel.show)) --(0.7,0.85)
        else
            b.label.text = "2x"
            mulReduPanel:slide(anchor(device.MulReduPanel.hide)) --(1.2, 0.85)
        end
    end  
    
    ---[[ 设置顶部控制按钮的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.mulReduButton.panel.pivot = vec2(1.0, 1.0)
    self.mulReduButton.panel.anchor = device.MulReduButton.show -- vec2(0.916, 0.99)
    self.mulReduButton.panel.align = {h=ui.CENTER, v=ui.TOP}  
    --]]  
    
    -- 创建二级子菜单区域
    self:makeSection("Mul|Redu",
    {
        -- 生成 Mul|Redu 调整切分位置菜单
        self:makeRangeButton(0,150,35,30),        
    })    
end 

-- 用于调整切分位置 x，y，z 尺寸的按钮：➕➖⬅️➡️
function MulReduPanel:makeRangeButton(x,y,w,h)
    local x,y,w,h = x,y,w,h    
    
    -- 把切分/合并部分的处理逻辑封装为6个函数，每个坐标轴2个   
    local function multX()
        -- 显示需 +1        
        -- xMiddle.text = self.dx+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = (sx+self.span)*2, sy, sz
        resizeVolume()  
        shouldResize = true
        
        -- print("X 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        -- local minX,maxX = 0, self.dx
        local minX,maxX = 0, sx/2-1
        local minY,maxY = 0, sy-1
        local minZ,maxZ = 0, sz-1
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, sx/2, 0, 0)
        
        local s = 0
        for k=maxX,minX,-1 do
            self:iterateVolume(k,k, minY, maxY, minZ, maxZ, sx/2-s,0,0,1,0,0)
            s=s+1
        end
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function multY()
        -- 显示需 +1        
        -- yMiddle.text = self.dy+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, (sy+self.span)*2, sz
        resizeVolume()  
        shouldResize = true
        
        -- print("Y 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        local minX,maxX = 0, sx-1
        -- local minY,maxY = 0, self.dy
        local minY,maxY = 0, sy/2- 1
        local minZ,maxZ = 0, sz-1
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, sy/2, 0)
        
        local s = 0
        for k=maxY,minY,-1 do
            self:iterateVolume(minX, maxX, k,k, minZ, maxZ, 0, sy/2-s,0,0,1,0)
            s=s+1
        end
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function multZ()
        -- 显示需 +1        
        -- zMiddle.text = self.dz+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, sy, (sz+self.span)*2
        resizeVolume()  
        shouldResize = true
        
        -- print("Z 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        sx, sy, sz = volume:size()
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        -- local minZ,maxZ = 0, self.dz
        local minZ,maxZ = 0, sz/2-1
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作，此时的 sz 为：原始sz+span
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, 0, sz/2)
        -- self:iterateVolume(minX, maxX, minY, maxY, maxZ-0, maxZ-0, 0, 0, sz/2-0)
        -- self:iterateVolume(minX, maxX, minY, maxY, maxZ-1, maxZ-1, 0, 0, sz/2-1)
        -- self:iterateVolume(minX, maxX, minY, maxY, maxZ-2, maxZ-2, 0, 0, sz/2-2)
        local s = 0
        for k=maxZ,minZ,-1 do
            self:iterateVolume(minX, maxX, minY, maxY, k, k, 0, 0, sz/2-s,0,0,1)
            s=s+1
        end
        
        -- 单独处理最左侧一列
        -- self:iterateVolume(minX, maxX, minY, maxY, 0, 0, 0, 0, 1)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function reduX()
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        -- local minX,maxX = math.floor(sx/2), math.floor(sx/2)+math.floor(sx/2-self.span)
        local minX,maxX = 0, sx
        local minY,maxY = 0, sy
        local minZ,maxZ = 0, sz
        
        
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, -minX, 0, 0,0,0,0)
        
        local s = 1
        for k=0,maxX,2 do
            -- print("redu k: ",k)
            self:iterateVolumeRedu(k, k, minY, maxY, minZ, maxZ, -k/2,0,0, 0,0,0)
            s=s+1
        end
        
        -- 让修改生效
        saveSnapshot()
        
        -- 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = math.floor(sx/2)-self.span, sy, sz
        -- SizeX,SizeY,SizeZ = math.floor(sx/2), sy, sz
        -- print("X 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true
    end
    
    local function reduY()
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx-1
        -- local minY,maxY = math.floor(sy/2), math.floor(sy/2)+math.floor(sy/2-self.span)
        local minY,maxY = 0, sy-1
        local minZ,maxZ = 0, sz-1
        
        -- print("Y merge中的 minX,maxX: ",minY,maxY)
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, -minY, 0,0,0,0)
        
        local s = 1
        for k=0,maxY,2 do
            -- print("redu k: ",k)
            self:iterateVolumeRedu(minX, maxX, k, k, minZ, maxZ, 0, -k/2,0, 0,0,0)
            s=s+1
        end
        
        -- 让修改生效
        saveSnapshot()
        
        -- 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = sx, math.floor(sy/2)-self.span, sz
        -- print("Y 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true
    end
    
    local function reduZ()
        -- sx, sy, sz = volume:size()
        -- volume:loadSnapshot(snapshots[#snapshots])
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        -- 合并时不需要追求使用精确的范围值：self.dz，只要把新增加的部分全部扫描一遍，保证不会遗漏即可
        -- local minZ,maxZ = math.floor(sz/2), math.floor(sz/2) + math.floor(sz/2-self.span)
        local minZ,maxZ = 0, sz-1
        
        -- print("Z merge中的 minZ,maxZ: ",minZ,maxZ)
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, 0, -minZ)
        
        -- self:iterateVolumeRedu(minX, maxX, minY, maxY, minZ+1, minZ+1, 0, 0, -1, 0,0,0)
        -- self:iterateVolumeRedu(minX, maxX, minY, maxY, minZ+3, minZ+3, 0, 0, -2, 0,0,0)
        -- self:iterateVolumeRedu(minX, maxX, minY, maxY, minZ+5, minZ+5, 0, 0, -3, 0,0,0)
        -- self:iterateVolumeRedu(minX, maxX, minY, maxY, minZ+7, minZ+7, 0, 0, -4, 0,0,0)
        local s = 1
        for k=0,maxZ,2 do
            print("redu k: ",k)
            self:iterateVolumeRedu(minX, maxX, minY, maxY, k, k, 0, 0, -k/2, 0,0,0)
            s=s+1
        end
        
        -- 让修改生效
        saveSnapshot()
        
        ---[[ 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = sx, sy, math.floor(sz/2)-self.span
        -- print("Z 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true 
        --]]       
    end
    
    ------
    --[[ 实时显示切分点数值
    self.xMiddle = ui.label({x=x+50, y=y-100, w=w, h=h, text= self.dx+1, alignment=CENTER})
    self.yMiddle = ui.label({x=x+150, y=y-50, w=w, h=h, text= self.dy+1, alignment=CENTER})
    self.zMiddle = ui.label({x=x+150, y=y-100, w=w, h=h, text= self.dz+1, alignment=CENTER})
    
    local xMiddle,yMiddle,zMiddle = self.xMiddle, self.yMiddle, self.zMiddle
    --]]
    
    local function moveLeft(offX,offY,offZ)
        volume:loadSnapshot(snapshots[#snapshots])
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, sy, sz
        resizeVolume()  
        shouldResize = true
        
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        local minZ,maxZ = 0, sz-1
        local step = 1
        
        self:iterateVolumeMove(minX, maxX, minY, maxY, minZ,maxZ, step,offX,offY,offZ)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function moveRight(offX,offY,offZ)
        volume:loadSnapshot(snapshots[#snapshots])
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, sy, sz
        resizeVolume()  
        shouldResize = true
        
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        local minZ,maxZ = 0, sz-1
        local step = -1
        
        self:iterateVolumeMove(maxX,minX, maxY, minY,maxZ,minZ,step, offX,offY,offZ)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    -------
    local xTitle = ui.button({x=x, y=y, w=w,h=h,text="X :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        onPressed=function(b)                         
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                
                table.insert(self.multX, multX)  
                table.insert(self.reduX, reduX)
                self.dx = self.step                              
            else                   
                table.remove(self.multX, #self.multX)  
                table.remove(self.reduX, #self.reduX) 
                self.dx = 0                            
            end        
        end})
    
    local yTitle = ui.button({x=x+50, y=y, w=w,h=h,text="Y :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        onPressed=function(b)                         
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                
                table.insert(self.multY, multY)  
                table.insert(self.reduY, reduY)   
                self.dy = self.step                                                         
            else                   
                table.remove(self.multY, #self.multY)  
                table.remove(self.reduY, #self.reduY) 
                self.dy = 0                             
            end        
        end})
    
    
    local zTitle = ui.button({x=x+100, y=y, w=w,h=h,text="Z :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        onPressed=function(b)                         
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                
                table.insert(self.multZ, multZ)  
                table.insert(self.reduZ, reduZ)   
                self.dz = self.step                                                         
            else                   
                table.remove(self.multZ, #self.multZ)  
                table.remove(self.reduZ, #self.reduZ)
                self.dz = 0                              
            end        
        end})
    
    
    ------
    -- 整体左移/下移/后移
    local xLeft =ui.button({x=x, y=y-50, w=w, h=h, text="◀️", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b)                         
            -- b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            --[[
            if b.selected then
                if self.dx>0 then                   
                    self.dx = self.dx-1                    
                end  
                multX()                
            else                   
                reduX()
            end
            --]]
            moveLeft(-self.dx, -self.dy, -self.dz)
        end})
    
    -- 整体右移/上移/前移
    local xRight = ui.button({x=x+100, y=y-50, w=w, h=h, text="▶️", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b)                       
            -- b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            --[[
            if b.selected then
                if self.dx<self.sx-2 then    
                    -- print("sx volume:", sx)                  
                    self.dx = self.dx+1                    
                end 
                multX()                  
            else                    
                reduX()
            end
            --]]
            moveRight(self.dx, self.dy, self.dz)
        end})
    
    -- 循环移动
    local xMiddle =ui.button({x=x+50, y=y-50, w=w, h=h, text="loop", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        selectedBg=asset.builtin.UI.Blue_Box_Tick,
        onPressed=function(b) 
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674) 
            
            if b.selected then
                self.loop = true
            else
                self.loop = false
            end
        end})
    
    -- 倍减
    local zLeft =ui.button({x=x, y=y-100, w=w+30, h=h, text="1/2", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)  
            
            --[[
            if b.selected then
                -- 限制 self.dz 范围，不能小于0，最小可以等于0
                if self.dz>0 then
                    self.dz = self.dz-1
                end
                -- splitZ()
                mergeZ()
            else
                -- mergeZ()
                splitZ()
            end
            --]]
            -- reduZ()
            for k,v in pairs(self.reduX) do
                v()
            end
            for k,v in pairs(self.reduY) do
                v()
            end
            for k,v in pairs(self.reduZ) do
                v()
            end
            
        end})
    
    -- 倍增
    local zRight = ui.button({x=x+100-30, y=y-100, w=w+30, h=h, text="2x", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            -- b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            --[[
            if b.selected then                
                -- 限制 self.dz 范围，不能大于 sz-1，最大可以等于 sz-1 ，这里的 sz 是 volume 最初的 sz   
                if self.dz<self.sz-2 then                   
                    self.dz = self.dz+1
                end
                splitZ()
                
            else
                mergeZ()
            end
            --]]
            
            -- multZ()
            for k,v in pairs(self.multX) do
                v()
            end
            for k,v in pairs(self.multY) do
                v()
            end
            for k,v in pairs(self.multZ) do
                v()
            end
        end})
    
    -- return xTitle,yTitle,zTitle,xLeft,xMiddle,xRight,yLeft,yMiddle,yRight,zLeft,zMiddle,zRight
    return xTitle,yTitle,zTitle,xLeft,xMiddle,xRight,zLeft,zRight
end

function MulReduPanel:slide(x,y)
    tween(0.6, self.anchor, {x = x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end

--[[
function MulReduPanel:close(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 0.1}, tween.easing.cubicInOut) 
end
--]]

function MulReduPanel:makeSection(name, items)
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

--[[ 子类如何显式调用父类的 update() ?  用下面的写法
function MulReduPanel:update()
    ui.panel.update(self)
    -- self.mulReduButton:update()
    
    -- self.mulReduButton:draw()
    
    self.sx, self.sy, self.sz = volume:size()
    
end
--]]

function MulReduPanel:draw()
    ui.panel.update(self)
    self.sx, self.sy, self.sz = volume:size()
    ui.panel.draw(self)
    
    self.mulReduButton:draw()
end


-- 定义一个volume遍历迭代函数，功能相当于把某区域内的所有方块剪切，并放置到另一位置
function MulReduPanel:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, offsetX, offsetY, offsetZ,tx,ty,tz)
    local minX, maxX, minY, maxY, minZ, maxZ = minX, maxX, minY, maxY, minZ, maxZ 
    local offsetX, offsetY, offsetZ = offsetX, offsetY, offsetZ
    for x = maxX, minX, -1 do
        for y = maxY,minY,-1  do
            for z = maxZ,minZ,-1  do
                local name = volume:get(x,y,z,BLOCK_NAME)
                if name and name ~= "Empty" then 
                    local s = volume:get(x,y,z, BLOCK_STATE)
                    local r = (s>>24) & 255
                    local g = (s>>16) & 255   
                    local b = (s>>8) & 255     
                    local collor = color(r,g,b)
                    -- 原来的位置清除掉
                    volume:set(x, y, z, "name", "Empty", "color", collor)
                    
                    -- 假设空间向右扩展，倍增时先计算最右侧的一列
                    volume:set(x+offsetX, y+offsetY, z+offsetZ, "name", name, "color", collor)
                    
                    volume:set(x+offsetX-tx, y+offsetY-ty, z+offsetZ-tz, "name", name, "color", collor)
                end
            end
        end
    end
end

-- 倍减
function MulReduPanel:iterateVolumeRedu(minX, maxX, minY, maxY, minZ, maxZ, offsetX, offsetY, offsetZ)
    local minX, maxX, minY, maxY, minZ, maxZ = minX, maxX, minY, maxY, minZ, maxZ 
    local offsetX, offsetY, offsetZ = offsetX, offsetY, offsetZ
    for x = minX,maxX,1 do
        for y = minY,maxY,1  do
            for z = minZ,maxZ,1  do
                local name = volume:get(x,y,z,BLOCK_NAME)
                -- if name and name ~= "Empty" then 
                if name then 
                    local s = volume:get(x,y,z, BLOCK_STATE)
                    local r = (s>>24) & 255
                    local g = (s>>16) & 255   
                    local b = (s>>8) & 255     
                    local collor = color(r,g,b)
                    
                    -- 原来的位置置空
                    volume:set(x, y, z, "name", "Empty", "color", collor)
                    
                    -- 假设空间向右扩展，倍减时先计算最左侧的一列
                    volume:set(x+offsetX, y+offsetY, z+offsetZ, "name", name, "color", collor)
                    
                end
            end
        end
    end
end

-- 移动
function MulReduPanel:iterateVolumeMove(minX, maxX, minY, maxY, minZ, maxZ, step, offX, offY, offZ)
    local minX, maxX, minY, maxY, minZ, maxZ = minX, maxX, minY, maxY, minZ, maxZ 
    local offX, offY, offZ = offX, offY, offZ
    local step = step
    for x = minX,maxX, step do
        for y = minY,maxY, step  do
            for z = minZ,maxZ, step  do
                local name = volume:get(x,y,z,BLOCK_NAME)
                if name and name ~= "Empty" then 
                    local s = volume:get(x,y,z, BLOCK_STATE)
                    local r = (s>>24) & 255
                    local g = (s>>16) & 255   
                    local b = (s>>8) & 255     
                    local collor = color(r,g,b)
                    -- 原来的位置清除掉
                    volume:set(x, y, z, "name", "Empty", "color", collor)                                      
                    
                    -- 整体移动
                    if self.loop then
                        volume:set((x+offX+sx)%(sx), (y+offY+sy)%(sy), (z+offZ+sz)%(sz), "name", name, "color", collor)  
                        
                        -- 需要把左边被 self.sx 切掉的部分补齐到最右侧
                        -- volume:set((x+sx-offX)%sx, (x+sy-offY)%(sy), (z+sz-offZ)%(sz), "name", name, "color", collor)  
                    else
                        volume:set(x+offX, y+offY, z+offZ, "name", name, "color", collor)  
                    end
                    
                end
            end
        end
    end
end
--]==]
----
