Player = class()

function Player:init(volume)
    -- Tool handles editing the voxel volume
    -- 底层编辑模块，执行实际的模型编辑操作
    tool = Tool()  
    snapshots = {}    
    touches.addHandler(tool, -1, false)
    
    createGrid()
    
    -- 使用 EditTool 类重写操作菜单
    editTool = EditTool(20,HEIGHT/2,370,500)
    
    -- 生成子菜单 MirrorMenu
    mirrorMenu = MirrorMenu(20,HEIGHT/2,370,500)
    
    -- 生成子菜单 ConfigMenu
    configMenu = ConfigMenu(20,HEIGHT/2,370,500)
    
    -- 生成子菜单 ModelMenu
    modelMenu = ModelMenu(20,HEIGHT/2, 370, 500)
    
    -- 点击 load 时生成物品清单列表面板
    itemPanel = ItemPanel()
    
    -- 点击 unit 时生成基本 unit 清单列表面板
    unitPanel = UnitPanel()
    
    -- 模型缩放/移动面板
    mulReduPanel = MulReduPanel(WIDTH - 140, HEIGHT-60,50,50)
    
    -- 模型切片/合并面板，可灵活选择切分点与坐标轴
    splitMergePanel = SplitMergePanel(WIDTH - 140, HEIGHT-60,50,50)
    
    -- 顶部状态条
    -- statusPanel = StatusPanel(30,HEIGHT/2,100,30)
    
    -- 新色彩面板
    newColorPanel = NewColorPanel()
end

function Player:update()
    -- 更新 grids
    for k,v in pairs(grids) do
        v:update()
    end
    
    if shouldResize then
        resizeVolume()
    end
    
    -- 绘制可编辑区域范围，可注释关闭
    if showRange then
        blockRange()
    end
end

function Player:draw()
    -- 模型加载菜单
    itemPanel:draw()
    
    -- 模型编辑：基本单位选择菜单
    unitPanel:draw();   
     
    -- 模型编辑：基本配色选择  
    -- unitPanel.colorPanel:update(); unitPanel.colorPanel:draw() 
    
    -- 模型编辑：完整配色选择
    newColorPanel:draw() 
    
    -- 模型编辑：基本编辑命令
    editTool:draw()
    
    -- 子菜单：镜像    
    mirrorMenu:draw();
    
    -- 子菜单：设置网格
    configMenu:draw()
    
    -- 子菜单：模型保存/加载
    modelMenu:draw()
    
    -- 模型编辑：缩放/移动
    mulReduPanel:draw()   
    
    -- 模型编辑：切分/合并菜单
    splitMergePanel:draw()
end

function createGrid()
    local xc,yc,zc = color(250),color(18, 8, 231),color(10, 222, 31)
    
    -- 生成编辑区的格子
    grids = 
    {
        -- 缺省只显示底部的格子：bottom
        bottom = Grid(vec3(0,1,0), vec3(0,0,0), 1, vec3(sx,sy,sz),xc, true),
        top = Grid(vec3(0,-1,0), vec3(0,sy,0), 1, vec3(sx,sy,sz), xc,false),
        left = Grid(vec3(1,0,0), vec3(0,0,0), 1, vec3(sx,sy,sz), yc,true),
        right = Grid(vec3(-1,0,0), vec3(sx,0,0), 1, vec3(sx,sy,sz), yc,false),
        front = Grid(vec3(0,0,1), vec3(0,0,0), 1, vec3(sx,sy,sz), zc,true),
        back = Grid(vec3(0,0,-1), vec3(0,0,sz), 1, vec3(sx,sy,sz), zc,false)
    }
end

-- 更新网格
function updateGrid()
    grids.right.origin.x = sx
    grids.back.origin.z = sz
    grids.top.origin.y = sy
    
    for k,v in pairs(grids) do
        v.size.x = sx
        v.size.y = sy
        v.size.z = sz
        v:modified()
    end
end

-- 重设 volume 尺寸
-- resize() 有 bug，在处理 x 轴时会 crash
function resizeVolume()
    if volume and SizeX and SizeY and SizeZ then
        volume:resize(SizeX, SizeY, SizeZ)
        
        sx, sy, sz = volume:size()
        updateGrid()
        
        viewer.target = vec3(sx/2 + 0.5, sy/2 + 0.5, sz/2 + 0.5)
        viewer.origin = viewer.target
        
        shouldResize = false
        saveSnapshot()
    end
end

---