-- 切分/合并子菜单：灵活选择切分点，对模型进行切分/合并操作
-- 效果示范：ABCDE => CDE | AB

SplitMergePanel = class(ui.panel)

function SplitMergePanel:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    
    self.fill = color(103, 220, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.pivot = vec2(1.0, 1.0)
    self.anchor = vec2(1.2, 0.85)
    
    self.w = w
    self.h = h
    self.align = {h = ui.RIGHT, v = ui.TOP}
    self.bg = asset.builtin.UI.Grey_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    -- 设置切分后被切掉部分原来位置的填充类型，可使用 "Empty"，或 "Water"
    self.empty = "New Water"
    
    self.sx, self.sy, self.sz = volume:size()
    SizeX,SizeY,SizeZ = self.sx, self.sy, self.sz
    
    -- 设定切分的缺省位置：模型中间，范围[0, sx-1]，这里的 sx 是 volume 未扩容前模型的原始尺寸
    -- 计算时从0开始[坐标值]，UI显示时从1开始
    self.dx = math.floor(self.sx/2)
    self.dy = math.floor(self.sy/2)
    self.dz = math.floor(self.sz/2)
    
    -- 设定切片之间放置的间隔，该间隔放在 volume 最右侧
    self.span = 1
    
    self:makeSection("Split|Merge",
    {
        -- 生成 Split|Merge 调整切分位置菜单
        self:makeRangeButton(0,150,35,30),   
        -- self:makeDocArea(0,-350,35,30),            
    })   
    
    ---[[ 创建控制按钮，用于打开模型切片/合并面板按钮
    -- self.mulReduButton = ControlButton(1,1,50,50,"fitSrc")
    -- self.mulReduButton = ControlButton(WIDTH - 130, HEIGHT-60, 50, 50, "2x")
    self.splitVolumeButton = ControlButton(1,1,50,50,"split")
    -- print("self.mulReduButton ", self.mulReduButton)
    -- self.controlButton.title.anchor = vec2(0.5,0.5)
    self.splitVolumeButton.button.onPressed=function(b) 
        -- 打开二级菜单，设置
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)    
        
        if b.selected then
            b.label.text = "close"
            splitMergePanel:slide(0.85,0.85)
        else
            b.label.text = "split"
            splitMergePanel:slide(1.4, 0.85)
        end
    end  
    
    -- 帮助文档
    self.showDoc = true
    self:makeSection("Doc",
    {
        -- 生成 Split|Merge 调整切分位置菜单
        self:makeDocArea(0,350,350,30),        
    })   
    text("444444444444",500,500)
    
    
    ---[[ 设置顶部控制按钮的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.splitVolumeButton.panel.pivot = vec2(1.0, 1.0)
    self.splitVolumeButton.panel.anchor = vec2(0.98, 0.99)
    self.splitVolumeButton.panel.align = {h=ui.CENTER, v=ui.TOP}  
    --]]       
end 

-- 用于显示帮助文档的区域
function SplitMergePanel:makeDocArea(x,y,w,h)
    local x,y,w,h = x,y,w,h
    
    -- 实时显示切分点数值
    self.doc = ui.label({x=x, y=y-200, w=w, h=h, text="help!eerrrffghhhjjhrewwdtgfr", alignment=CENTER})
end

-- 用于调整切分位置 x，y，z 尺寸的按钮：➕➖⬅️➡️
function SplitMergePanel:makeRangeButton(x,y,w,h)
    local x,y,w,h = x,y,w,h
    
    local xTitle = ui.button({x=x, y=y, w=w,h=h,text="X :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local yTitle = ui.button({x=x, y=y-50, w=w,h=h,text="Y :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local zTitle = ui.button({x=x, y=y-100, w=w,h=h,text="Z :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    
    -- 实时显示切分点数值
    self.xMiddle = ui.label({x=x+100, y=y, w=w, h=h, text= self.dx+1, alignment=CENTER})
    self.yMiddle = ui.label({x=x+100, y=y-50, w=w, h=h, text= self.dy+1, alignment=CENTER})
    self.zMiddle = ui.label({x=x+100, y=y-100, w=w, h=h, text= self.dz+1, alignment=CENTER})
    
    local xMiddle,yMiddle,zMiddle = self.xMiddle, self.yMiddle, self.zMiddle
    
    -- 把切分/合并部分的处理逻辑封装为6个函数，每个坐标轴2个   
    local function splitX()
        -- 显示需 +1        
        xMiddle.text = self.dx+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = (sx+self.span)*2, sy, sz
        resizeVolume()  
        shouldResize = true
        
        -- print("X 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        local minX,maxX = 0, self.dx
        local minY,maxY = 0, sy
        local minZ,maxZ = 0, sz
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, sx/2+self.span, 0, 0)
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, sx/2, 0, 0)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function splitY()
        -- 显示需 +1        
        yMiddle.text = self.dy+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, (sy+self.span)*2, sz
        resizeVolume()  
        shouldResize = true
        
        -- print("Y 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        local minX,maxX = 0, sx
        local minY,maxY = 0, self.dy
        local minZ,maxZ = 0, sz
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, sy/2+self.span, 0)
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, sy/2, 0)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function splitZ()
        -- 显示需 +1        
        zMiddle.text = self.dz+1
        
        -- 使用已有的的全局变量：sx,sy,sz
        sx, sy, sz = volume:size()
        
        -- 扩大 volume 容纳空间，方便操作
        SizeX,SizeY,SizeZ = sx, sy, (sz+self.span)*2
        resizeVolume()  
        shouldResize = true
        
        -- print("Z 倍增空间后的 sx, sy, sz: ",sx,sy,sz)
        -- 能原样恢复的关键是 sx/2 在两个分支中的求值结果必须一样
        -- 必须保证原始模型填满整个 volume 空间
        -- 循环从 0 开始，所以 maxX 应该 -1 才能保证从中间切开
        sx, sy, sz = volume:size()
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        local minZ,maxZ = 0, self.dz
        
        -- 迭代遍历 volume，把切下来的部分平移到扩容后的 volume 的右半侧，方便操作，此时的 sz 为：原始sz+span
        -- self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, 0, sz/2+self.span)
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, 0, sz/2)
        
        -- 让修改生效
        saveSnapshot()
    end
    
    local function mergeX()
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        -- local minX,maxX = math.floor(sx/2), math.floor(self.dx+sx/2)
        local minX,maxX = math.floor(sx/2), math.floor(sx/2)+math.floor(sx/2-self.span)
        local minY,maxY = 0, sy
        local minZ,maxZ = 0, sz
        
        -- print("X merge中的 minZ,maxZ: ",minZ,maxZ)
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, -minX, 0, 0)
        
        -- 让修改生效
        saveSnapshot()
        
        -- 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = math.floor(sx/2)-self.span, sy, sz
        -- SizeX,SizeY,SizeZ = math.floor(sx/2), sy, sz
        -- print("X 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true
    end
    
    local function mergeY()
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx
        -- local minY,maxY = math.floor(sy/2), math.floor(sy/2)+self.dy
        local minY,maxY = math.floor(sy/2), math.floor(sy/2)+math.floor(sy/2-self.span)
        local minZ,maxZ = 0, sz
        
        -- print("Y merge中的 minX,maxX: ",minY,maxY)
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, -minY, 0)
        
        -- 让修改生效
        saveSnapshot()
        
        -- 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = sx, math.floor(sy/2)-self.span, sz
        -- print("Y 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true
    end
    
    local function mergeZ()
        sx, sy, sz = volume:size()
        
        -- 用 minX,maxX 来选择扫描范围，这里只需要扫描整个 sx 的 1/4 范围(也就是被平移出去的半个模型)
        -- 这里 minX,maxX 的取值必须跟前面分支的平移的x的起始值一致，这里的 sx 必定是偶数
        local minX,maxX = 0, sx-1
        local minY,maxY = 0, sy-1
        -- local minZ,maxZ = math.floor(sz/2), math.floor(sz/2) + self.dz
        -- 合并时不需要追求使用精确的范围值：self.dz，只要把新增加的部分全部扫描一遍，保证不会遗漏即可
        local minZ,maxZ = math.floor(sz/2), math.floor(sz/2) + math.floor(sz/2-self.span)
        
        -- print("Z merge中的 minZ,maxZ: ",minZ,maxZ)
        -- 迭代遍历 volume，把 volume 右半侧侧编辑好的部分平移到最左侧，恢复模型原样
        self:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, 0, 0, -minZ)
        
        -- 让修改生效
        saveSnapshot()
        
        -- 缩减尺寸，恢复为原来 volume 的尺寸，这里要考虑奇数无法整除的情况
        SizeX,SizeY,SizeZ = sx, sy, math.floor(sz/2)-self.span
        -- print("Z 恢复后的 SizeX,SizeY,SizeZ: ",SizeX,SizeY,SizeZ)
        resizeVolume()  
        shouldResize = true        
    end
    
    local xLeft =ui.button({x=x+50, y=y, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b)                         
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                if self.dx>0 then                   
                    self.dx = self.dx-1                    
                end  
                splitX()                
            else                   
                mergeX()
            end
            
        end})
    
    local xRight = ui.button({x=x+150, y=y, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b)                       
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                if self.dx<self.sx-2 then    
                    -- print("sx volume:", sx)                  
                    self.dx = self.dx+1                    
                end 
                splitX()                  
            else                    
                mergeX()
            end
            
        end})
    
    local yLeft =ui.button({x=x+50, y=y-50, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674) 
            
            if b.selected then
                if self.dy>0 then
                    self.dy = self.dy-1
                end                
                splitY()
            else
                mergeY()
            end
        end})
    
    local yRight = ui.button({x=x+150, y=y-50, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)  
            
            if b.selected then
                -- print("sy volume:", sy)
                if self.dy<self.sy-2 then
                    self.dy = self.dy+1
                end                
                splitY()
            else
                mergeY()
                
            end
        end})
    
    local zLeft =ui.button({x=x+50, y=y-100, w=w, h=h, text="➖", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)  
            
            if b.selected then
                -- 限制 self.dz 范围，不能小于0，最小可以等于0
                if self.dz>0 then
                    self.dz = self.dz-1
                end
                splitZ()
            else
                mergeZ()
            end
        end})
    
    local zRight = ui.button({x=x+150, y=y-100, w=w, h=h, text="➕", 
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        onPressed=function(b) 
            b.selected = not b.selected
            sound(SOUND_PICKUP, 41674)   
            
            if b.selected then
                
                -- 限制 self.dz 范围，不能大于 sz-1，最大可以等于 sz-1 ，这里的 sz 是 volume 最初的 sz   
                if self.dz<self.sz-2 then                   
                    self.dz = self.dz+1
                end
                splitZ()
            else
                mergeZ()
            end
            
        end})
    
    return xTitle,yTitle,zTitle,xLeft,xMiddle,xRight,yLeft,yMiddle,yRight,zLeft,zMiddle,zRight
end

function SplitMergePanel:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end

--[[
function SplitMergePanel:close(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 0.1}, tween.easing.cubicInOut) 
end
--]]

function SplitMergePanel:makeSection(name, items)
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

-- 子类如何显式调用父类的 update() ?  用下面的写法
function SplitMergePanel:draw()
    ui.panel.update(self)
    
    self.sx, self.sy, self.sz = volume:size()
    
    if self.xMiddle then
        self.xMiddle.text = self.dx+1
    end
    
    if self.yMiddle then
        self.yMiddle.text = self.dy+1
    end
    
    if self.zMiddle then
        self.zMiddle.text = self.dz+1
    end
    
    if showSplit then
        self.empty = "New Water"
    else 
        self.empty = "Empty"
    end
    
    ui.panel.draw(self)
    self.splitVolumeButton:draw()
end


-- 定义一个volume遍历迭代函数，功能相当于把某区域内的所有方块剪切，并放置到另一位置
function SplitMergePanel:iterateVolume(minX, maxX, minY, maxY, minZ, maxZ, offsetX, offsetY, offsetZ)
    local minX, maxX, minY, maxY, minZ, maxZ = minX, maxX, minY, maxY, minZ, maxZ 
    local offsetX, offsetY, offsetZ = offsetX, offsetY, offsetZ
    for x = minX, maxX do
        for y = minY, maxY do
            for z = minZ, maxZ do
                local name = volume:get(x,y,z,BLOCK_NAME)
                if name and name ~= "Empty" then 
                    local s = volume:get(x,y,z, BLOCK_STATE)
                    local r = (s>>24) & 255
                    local g = (s>>16) & 255   
                    local b = (s>>8) & 255     
                    local collor = color(r,g,b)
                    
                    -- 切分时先平移半个模型到右侧，offsetX = sx/2+span 方便操作模型内部
                    -- volume:set(x+sx/2+span,y,z,"name",name,"color", collor)
                    -- 合并时平移半个模型到原位最左侧，offsetX = -minX
                    -- volume:set(x-minX,y,z,"name", name, "color", collor)
                    volume:set(x+offsetX, y+offsetY, z+offsetZ, "name", name, "color", collor)
                    -- 原来的位置设为 "Empty"，为便于理解可暂时设为 "Water" 用于演示
                    volume:set(x,y,z,"name",self.empty,"color", collor)                                
                end
            end
        end
    end
end

----
