-- 系统状态条：显示当前各种状态信息
-- 当前命令的效果解释

StatusPanel = class(ui.panel)

function StatusPanel:init(x,y,w,h)
    -- you can accept and set parameters here
    local x,y,w,h = x,y,w,h
    ui.panel.init(self, {x=x, y=y, w=w, h=h})
    -- UI.Panel:init(x or 0, y or 0, w or 270, h or HEIGHT-40)
    self.fill = color(103, 173, 220, 107)
    self.loadButton = nil
    self.saveButton = nil
    
    self.anchor = vec2(0.4, 0.99)
    self.pivot = vec2(0.5, 1.0)
    self.w = w
    self.h = h
    self.align = {h = ui.CENTER, v = ui.TOP}
    self.bg = asset.builtin.UI.Green_Panel
    self.fill = color(208, 224, 12, 199)
    self.inset = 10
    self.cornerRadius = 5
    
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    
    
    self:makeSection("StatusBar",
    {
        -- 生成 size 调整菜单
        self:makeLabel(0,0,40,30),
        
        -- self:makeValue(0,40,100,30),
    })        
end 

-- 用于调整 x，y，z 尺寸的按钮
function StatusPanel:makeLabel(x,y,w,h)
    local x,y,w,h = x,y,w,h
    
    local xTitle = ui.button({x=x, y=y, w=w,h=h,text="file: ",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local yTitle = ui.button({x=x+150, y=y, w=w,h=h,text="Y :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    local zTitle = ui.button({x=x+300, y=y, w=w,h=h,text="Z :",alignment=CENTER,
        normalBg = asset.builtin.UI.Blue_Button10,
    highlightedBg = asset.builtin.UI.Blue_Button10})
    
    
    -- 实时显示模型长宽高数据
    if itemPanel.slot then
        self.fileName = itemPanel.slot.block.name
    end
    
    self.xMiddle = ui.label({x=x+40+10, y=y, w=w, h=h, text=self.fileName or "", alignment=CENTER})
    self.yMiddle = ui.label({x=x+200+10, y=y, w=w, h=h, text=SizeY, alignment=CENTER})
    self.zMiddle = ui.label({x=x+340, y=y, w=w, h=h, text=SizeZ, alignment=CENTER})
    
    local xMiddle,yMiddle,zMiddle = self.xMiddle, self.yMiddle, self.zMiddle
    
    return xTitle,yTitle,zTitle,xMiddle,yMiddle,zMiddle
end

function StatusPanel:slide(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end

--[[
function StatusPanel:close(x,y)
    tween(0.6, self.anchor, {x=x or 0.9, y = y or 0.1}, tween.easing.cubicInOut) 
end
--]]

function StatusPanel:makeSection(name, items)
    -- 把标签加入 shelf 自身的孩子节点
    -- self:addChild(ui.label({x=5,y=0,w=75,h=20,text=name,alignment=LEFT}))
    
    -- 创建一个 panel 作为临时容器
    -- local container = ui.panel({x=0, y=0, w=self.panel.frame.w, h=30})
    local container = ui.panel({x=0, y=0, w=self.frame.w, h=30})
    container.bg = asset.builtin.UI.Grey_Panel
    container.fill = color(208, 224, 12, 199)
    container.align = {h = ui.CENTER, v = ui.TOP}
    
    -- 把所有该区段内创建的按钮全部加入 panel 容器的孩子节点
    for k,v in pairs(items) do
        container:addChild(v) 
    end
    
    -- 设定 panel 的布局
    -- container:layoutHorizontal(5, true)
    -- container.fill = color(31, 222, 10)
    
    -- 把 panel 容器加入 shelf 自身孩子节点
    self:addChild(container)
end

-- 子类如何显式调用父类的 update() ?
function StatusPanel:update()
    ui.panel.update(self)
    
    sx, sy, sz = volume:size()
    SizeX,SizeY,SizeZ = sx,sy,sz
    
    if self.xMiddle then
        self.xMiddle.text = "hello" or self.fileName
    end
    
    -- 实时显示尺寸
    if self.yMiddle then
        self.yMiddle.text = SizeX .. " x " ..SizeY .. " x " .. SizeZ
    end
    
    if self.zMiddle then
        self.zMiddle.text = SizeZ
    end
end

----
