-- 控制二级子菜单开启的按钮 
-- ControlButton

ControlButton = class()

function ControlButton:init(x, y, w, h, text)
    self.x = x or 1
    self.y = y or 1
    self.w = w or 50
    self.h = h or 50
    self.text = text or ""
    
    -- 面板的长度，宽度
    local w,h = w,h
    
    -- 新建一个 panel
    self.panel = ui.panel
    {
        pivot = vec2(0.0, 1.0),
        anchor = vec2(0.0, 1.0),
        w = w,
        h = h,
        align = {h = ui.CENTER, v = ui.TOP},
        bg = asset.builtin.UI.Grey_Panel,
        fill = color(0, 19),
        inset = 10,
    }
    
    -- 把 panel 设置为圆角矩形
    self.panel.cornerRadius = 5
    
    self.button  = self:slotButton()
    self.button.label.pivot = vec2(0.0, 1.0)
    self.button.label.anchor = vec2(0.0, 1.0)
    self.button.label.fontSize = 20
end

--[[ 暂时不需要
function ControlButton:slide(anchorX, anchorY)
    local x,y = anchorX, anchorY
    tween(0.6, self.panel.anchor, {x = x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end
--]]

-- 创建唯一一个的按钮
function ControlButton:slotButton()
    -- 这里的每个按钮都比较独立，跟其他按钮没有交互作用
    local button = ui.button
    {
        x = self.x,
        y = self.y,
        w = self.w,
        h = self.h,
        text = self.text or "unit",
        
        normalBg = asset.builtin.UI.Blue_Button11,
        highlightedBg = asset.builtin.UI.Blue_Button10,
        -- selectedBg=asset.builtin.UI.Blue_Box_Tick,        
    }
    
    -- 把每个新建的按钮都加入 self.panel 的子节点，统一更新，绘制
    self.panel:addChild(button)
    
    return button
end

function ControlButton:draw()
    -- panel 更新与绘制
    self.panel:update()
    self.panel:draw()
end

----



