-- MyAmuseVoxel

-----------------------------------------
-- My Amuse Voxel Editor
-- Author: BinaryBlues
-- Based on Voxel Editor[the Codea built-in Sample] written by John Millard
-----------------------------------------
-- Description:
-- A Voxel Editor.
-- Use the editor to save and load voxels models in the cvox format (Codea Voxel).
-- Easy to deal with the internal room of model: split/merge.
-- Thanks: John Millard, UberGoober, SugarRay
-- Using John Millard's base code
-- Using UberGoober's undo/redo code, voxel models and the new block library.
-- Using SugarRay's objcTextView code.
-- Dependecies: UI, Cameras, Touches in Codea built-in Sample
-- https://talk.codea.io/t/myamusevoxel-a-voxel-editor-based-on-the-built-in-sample-voxel-editor
-- https://codea.io/talk/discussion/13390/make-an-app-like-anima-toon-with-codea-is-it-a-crazy-idea-i-want-to-try-it#latest
-----------------------------------------
-- require 'codea.legacy':export()
-- current version: V009[20240330]

viewer.mode = FULLSCREEN
viewer.showWarnings = false

oldViewer = viewer
-- supportedOrientations(CurrentOrientation)
-- WIDTH = WIDTH/2
-- Use this function to perform your initial setup
function setup()
    -- CurrentOrientation = PORTRAIT
    scene = craft.scene()
    
    ---[[
    local sunny = readText(asset.builtin.Environments.Night)
    local env = craft.cubeTexture(json.decode(sunny))
    scene.sky.material.envMap = env
    scene.sun.eulerAngles = vec3(45, 45, 0)
    
    scene.ambientColor = color(87)
    scene.sky.active = true
    
    -- Setup camera and lighting
    scene.sun.rotation = quat.eulerAngles(15, 125, 0)
    --]]
    
    -- 生成所有 block 增加该语句可减少程序崩溃：模型中使用了未被定义的 block
    allBlocks = blocks()   
    
    -- Generate icon for solid block type (using Block Library:BlockPreview)
    solid = scene.voxels.blocks.Solid
    solid.static.icon = generateBlockPreview(solid)
    
    -- Create a volume for rendering our voxel model
    volumeEntity = scene:entity()
    volume = volumeEntity:add(craft.volume, 9, 9, 9)
    sx, sy, sz = volume:size()
    
    -- Helper class for interactive camera
    viewer = scene.camera:add(OrbitViewer, vec3(sx/2 + 0.5, sy/2 + 20.5, sz/2 + 0.5), 40, 1, 1000)
    viewer.rx = 45
    viewer.ry = -135
    
    
    -- The main UI
    myPlayer = Player(volume)
    
    shouldResize = true
    showRange = false
    showSplit = false
    shareModel = false
    sampleModel = false
    
    --[[ 新增一个 volume
    volumeEntity1 = scene:entity()
    volume1 = volumeEntity1:add(craft.volume, 9, 9, 9)
    sx, sy, sz = volume1:size()
    volume1:load(asset.documents.Airframe)
    --]]
    
    -- 当前操作模型设为 volume1
    -- volume = volume1
end

function update(dt) 
    scene:update(dt)
    
    myPlayer:update()
end

-- Perform 2D drawing (UI)
function draw()
    update(DeltaTime)
    scene:draw()    
    myPlayer:draw() 
end

-- 每次退出 viewer 时，把项目内部文件夹 Project:models 中的模型备份到 Documents:MyAmuseModels 文件夹中
function willClose()
    -- local s = viewer:snapshot()
    -- saveImage(asset.documents.MyAmuseModels.."hello.png", s)
    --viewer.alert("backup your models to ..")
    if asset.documents.MyAmuseModels then
        local volumeEntity = scene:entity()
        local volume = volumeEntity:add(craft.volume, 9, 9, 9)
        local vm = itemPanel.volumesModels
        for k,v in pairs(vm) do
            local name = v.name
            volume:load(v.volume)
            volume:save(asset.documents.MyAmuseModels..name)
        end
        -- saveText(asset.documents.MyAmuseModels.."hi.txt", #m)
        -- volume:save()
        volumeEntity:destroy()
    end
end

---



