-- 一个完整的色彩选择面板
-- 考虑到性能，可以尝试定义 lightButton 轻量级按钮，只保存最基本的颜色数据
NewColorPanel = class()

function NewColorPanel:init()
    self.isInventoryOpen = false
    self.inventory = nil
    self.hotbar = nil
    self.slot = nil
    self.tab = nil
    self.tabs = {}
    self.tabSlot = nil
    self.tabIndex = 1
    -- 设置模型文件加载路径：本项目文件夹内
    self.files = asset.models.all
    -- self.files = asset.documents.all
    self.blockIconPath = asset.colorIcons
    self.volumes = {}
    self.colors = {}
    self.icon = nil
    
    
    self.COLORS = generateColor()
    
    -- 模型清单主面板 self.inventory 的行，列，单位尺寸大小
    self.mRows = 16
    self.mCols = 4
    self.mGSize = 32
    
    -- 面板的长度，宽度
    -- local w,h =
    -- self.gridCols * self.gridSize + self.border * 2 + (self.gridCols-1) * self.spacing,
    -- self.gridRows * self.gridSize + self.border * 2 + (self.gridRows-1) * self.spacing
    local panelW, panelH =
    self.mCols * self.mGSize + 5*2 + (self.mCols-1)*5, 
    self.mRows * self.mGSize + 5*2 + (self.mRows-1)*5 + 5*2+64
    
    -- 新建一个背景 panel，可作为本类中所有控件的父节点
    self.panel = ui.panel
    {
        pivot = vec2(0.5, 1.0),
        anchor = vec2(1.5, 0.75),
        w = panelW,
        h = panelH,
        align = {h = ui.CENTER, v = ui.TOP},
        -- bg = "UI:Grey Panel",
        bg = asset.builtin.UI.Grey_Panel,
        fill = color(0, 25),
        inset = 10,
    }
    
    -- 取得指定目录下的所有 Voxel 模型，将其存入 self.volumes 表中，为每个模型生成预览图像
    self:getAllColors()
    
    self:calcParams()
    
    self:createInvPanel()
    
end

function NewColorPanel:calcParams()
    -- 遍历模型表 volumes，将所有的模型分成几批[1,25],[25+1,50],[50+1,75]，选择对应批次插入物品仓库中
    self.rangeUnit = self.mRows * self.mCols
    -- local min,max = {1,26,51},{25,50,75} 
    -- 模型总数为 37 时，区间分为：min,max = {1,26},{25,37} 
    self.min, self.max = {},{}  
    
    -- self.total = #self.volumes
    self.total = #self.colors
    -- 计算得到整除的商 m 和余数 n
    self.m = math.floor(self.total/self.rangeUnit)
    self.n = math.fmod(self.total,self.rangeUnit)
    for i=1,self.m do
        table.insert(self.min,(i-1)*self.rangeUnit+1)
        table.insert(self.max,i*self.rangeUnit)
    end
    
    -- 若整除，余数为0，则使其为1，避免临界状态
    if self.n == 0 then self.n = self.n +1 end
    
    -- 若余数不为0，则把最后一组没有被整除的余数计算后插入
    if self.n >0 then
        table.insert(self.min, self.m*self.rangeUnit+1)
        table.insert(self.max, self.m*self.rangeUnit+self.n)
    end
end


function NewColorPanel:createInvPanel()
    -- 根据 self.min 中元素个数，确定需要创建几列 tab 标签页
    local tabCol = #self.min
    
    -- 只创建一个 Inventory，每次在 self.tab 的回调函数中动态生成其图标/文字内容
    self.inventory = Inventory(self.mRows, self.mCols, self.mGSize, 5,5, function() end)
    
    -- 根据模型个数动态创建 tab 标签选项，这里只需要能选择 tab 索引并把它赋值给 self.tabIndex 就可以
    self.tab = Inventory(1, tabCol, 32, 5,10, function() end)    
    self.tab.itemCallback = function(inv, tabSlot)
        sound(SOUND_PICKUP, 41674)   
        -- 当前槽位按钮被选中时，保持选中状态，tabslot代表被选中的槽位
        inv:setSelected(tabSlot)
        
        -- 点击 tab时，用来设定 tab 标签上的文本内容和字体大小：也就是数字序号
        tabSlot.button.label.anchor = vec2(0.5, 0.5)
        tabSlot.button.label.fontSize = 20
        tabSlot.button.label.text = tabSlot.index
        
        -- 初始化 self.inventory 清单面板的显示
        self.tabIndex = tabSlot.index
        
        -- 先清除前一个 self.inventory 面板在每个槽位中的内容
        self.inventory:removeItem("")
        
        -- 动态加入当前索引区间(由 self.tabIndex 计算得到)的模型数据：图标，名称
        for volumeIndex = self.min[self.tabIndex], self.max[self.tabIndex] do
            -- print("volume index:", volumeIndex)
            -- local item = self.volumes[volumeIndex]
            local item = self.colors[volumeIndex]
            self.inventory:addItem(item)
        end   
        
        -- 整个 inventory 只定义了一个回调函数，参数 inventory 是它自身，参数 slot 是被点击的槽位
        -- 该回调函数是每个槽位的模型按钮，点击后加载对应模型
        -- self.tabs[self.tabIndex].itemCallback = function(inventory, slot)
        self.inventory.itemCallback = function(inventory, slot)
            -- 点击本槽位按钮时，立刻选定对应模型
            inventory:setSelected(slot)
            self.slot = slot
            
            -- 获取当前 hotbar 中被选中的槽位，目前返回 nil，说明没有选中
            -- local hotbarSlot = self.hotbar:getSelected()
            -- print("hotbarSlot: ", hotbarSlot)
            -- if hotbarSlot and slot.block then
            if slot.block then
                local block = slot.block
                
                -- 在整个面板最上方显示选中的槽位中保存的 block/volume 的名字
                -- inventory.title.text = block.name or block.longName
                sound(SOUND_PICKUP, 41674)   
                
                -- 回调函数：点击某槽位，则根据该槽位对应索引从 volumes 中选择模型，加载到当前编辑区
                local index = slot.index + (self.tabIndex-1) * self.rangeUnit
                -- self:loadVolumeModel(volume, self.volumes[index]) 
                -- print("self.tabIndex: ", i, index) 
                if index <= #self.colors then
                    -- 设置当前使用的颜色
                    tool.toolColor = self.colors[index].collor
                    
                    -- 确定方块类型为 Solid
                    tool.toolUnitType = "Solid"      
                end
            end
        end
    end
    
    -- 初始化时显示所有 tab 标签页面的编号
    for k,v in pairs(self.tab.slots) do
        local slot = v
        slot.button.label.anchor = vec2(0.5, 0.5)
        slot.button.label.fontSize = 20
        slot.button.icon.img = nil
        slot.button.label.text = k
        slot.block = nil
    end
    
    
    -- 把第一个 tab 标签页面外观设置为已选中，这里只能显示，点击选择模型时无法加载，必须手动点击 tab 按钮
    local firstTabSlot = self.tab:getSlot(1)
    self.tab:setSelected(firstTabSlot)
    
    -- 初始化 self.inventory 清单面板的显示
    -- self.tabIndex = firstTabSlot.index
    -- 手动执行 self.tab 的回调函数
    self.tab:itemCallback(firstTabSlot)
    
    
    -- 统一加入 self.panel 子节点，方便布局
    self.panel:addChild(self.tab.panel) 
    self.panel:addChild(self.inventory.panel) 
    
    -- 布局方式：有三种场景需要考虑，初始化时的缺省位置，开启时位置，关闭时位置
    -- 设置各控件在 self.panel 上的布局：这里是初始化位置
    self.inventory.panel.anchor = vec2(0.5, 1.5)
    self.inventory.panel.pivot = vec2(0.5, 0.0)
    self.inventory.panel.align = {h=ui.CENTER, v=ui.TOP}
    
    -- 设置 tab 的位置布局
    self.tab.panel.anchor = vec2(0.5, 1.0)
    self.tab.panel.pivot = vec2(0.5, 1.0)
    self.tab.panel.align = {h=ui.CENTER, v=ui.TOP}
    -- self.tab.panel.bg = asset.builtin.UI.Grey_Panel
    -- self.tab.panel.fill = color(0, 26)
    self.tab.panel.inset = 10
end


function NewColorPanel:getAllColors()
    
    local solid = scene.voxels.blocks.Solid
    self.icon = scene.voxels.blocks:get("Solid").icon
    -- solid.static.icon = generateBlockPreview(solid)
    ---[[ 遍历 COLORS 中所有的 color 
    for k,v in pairs(self.COLORS) do
        
        local collor = v
        local name = "color"..k
        local block = {volume=solid, collor=v, name=name, hasIcon=true, icon=self.icon}
        
        local blockImg = self:generateModelPreview(name, collor)
        
        block.icon = blockImg
        
        table.insert(self.colors, block) 
    end
    --]]
end

-- 向 self.volumes 中追加最新编辑保存的 volume 模型
function NewColorPanel:appendItem(v)
    
    local modelImg = self:generateModelPreview(v)
    
    -- 改造为跟block一致的表结构，可以合并代码，尽量使用 Inventory 原来的流程，减少循环
    local block = {volume=v, name=v.name, hasIcon=true, icon=modelImg}
    table.insert(self.volumes, block)   
    
    local item = self.volumes[#self.volumes]
    self.inventory:addItem(item)                   
end

function NewColorPanel:checkDup(name)
    for k,v in pairs(self.volumes) do
        -- print("name: ", name, v.name)
        if name == v.name then
            return true
        else
            return false
        end
    end
end

-- 显示/隐藏 (-0.4, 0.92)|.  (0.02, 0.92)/(-0.2, 0.92)
function NewColorPanel:slide(x,y)
    tween(0.6, self.panel.anchor, {x=x or 0.5, y = y or 1.5}, tween.easing.cubicInOut)
end

-- 显示物品清单
function NewColorPanel:showInventory()
    
    if self.isInventoryOpen then
        -- tween(0.6, self.panel.anchor, {x=1.5, y = 0.75}, tween.easing.cubicInOut)
        self:slide(anchor(device.NewColorPanel.hide))
        self.tab:slide(anchor(device.NewColorTab.hide))
        self.inventory:slide(anchor(device.NewColorInv.hide))
        self.isInventoryOpen = false
    else
        -- tween(0.6, self.panel.anchor, {x=0.85, y = 0.75}, tween.easing.cubicInOut)         
        self:slide(anchor(device.NewColorPanel.show))
        self.tab:slide(anchor(device.NewColorTab.show))
        self.inventory:slide(anchor(device.NewColorInv.show))
        -- self.inventory.panel.anchor = vec2(0.0, 0.1)
        self.isInventoryOpen = true       
    end
end


-- Uses the camera to generate previews of blocks before the scene starts
function NewColorPanel:generateModelPreview(name,collor)
    
    -- Try to read a cached version of the icon first
    -- local img = readImage("Project:"..block.name)
    -- 在本地目录下新建文件夹 unit，专门保存各种方块单元的图标
    -- local img = readImage(asset..block.name)
    local colorName = name
    local collor = collor
    local img = readImage(self.blockIconPath..colorName)
    
    -- print("ttt")  
    
    if img then
        return img
    end
    
    local camera = scene.camera:get(craft.camera)
    local sky = scene.sky
    
    local ortho = camera.ortho
    local orthoSize = camera.orthoSize
    
    --[[ 
    pb = craft.bloomEffect()
    pb.enabled = true 
    pb.iterations = 5
    pb.threshold = 0.06
    pb.softThreshold = 1.6
    pb.intensity = 0.06
    
    camera.hdr = true
    camera.colorTextureEnabled = true
    camera.clearDepthEnabled = true
    camera.clearColorEnabled = true
    camera.depthTextureEnabled = true
    camera:addPostEffect(pb)
    --]]
    
    camera.ortho = true
    camera.orthoSize = 0.9
    camera.entity.rotation = quat.eulerAngles(35, 45, 0)
    camera.entity.position = vec3(0.5, 10.5, 0.5) - camera.entity.forward * 50
    camera.clearColorEnabled = false
    -- 将 sky 设置为 false 可以得到背景透明的预览图标
    sky.active = false
    
    --[[ 加载方块形体
    local volumeObj = scene:entity()
    local volume = volumeObj:add(craft.volume, 1, 1, 1)   
    -- volume.model:getMaterial().showOutline = true
    -- volumeObj.scale= vec3(0.1,0.1,0.1)
    
    -- 实际执行模型加载
    -- self:loadVolumeModel(volume, model)
    -- 手工处理 tinted
    if block.tinted then
        volume:set(0,0,0,"name", block.name, "color", collor)   
        print("a")     
    else
        volume:set(0,0,0, block.name)
        print("b---")
    end
    --]]
    
    -- 为 model 拍照
    img = image(32, 32)
    setContext(img, true)
    
    pushStyle()
    pushMatrix()
    tint(collor)
    -- ellipseMode(CORNER)
    fill(251, 105)
    
    spriteMode(CORNER)
    
    -- 取得 Solid 的外观形状
    -- local icon = scene.voxels.blocks:get("Solid").icon
    local icon = self.icon
    sprite(icon, 0, 0, 32,32)
    
    camera:draw()
    popMatrix()
    popStyle()
    
    setContext()
    
    -- volumeObj:destroy() 
    
    camera.ortho = ortho
    camera.orthoSize = orthoSize
    camera.clearColorEnabled = true
    sky.active = true
    
    -- saveImage(asset..block.name, img)
    saveImage(self.blockIconPath..colorName, img)
    return img 
end

function NewColorPanel:draw()
    
    self.panel:update()
    self.panel:draw()
end

----

