-- 比较特殊的文本框控件，使用 objc 的 UITextView 控件，通过回调自动更新，不需要手动设置
-- Using SugarRay's objcTextView code.
-- https://codea.io/talk/discussion/13315/objectivec-integration-into-codea-revised-demo#latest

ObjcTextBox = class()

function ObjcTextBox:init(x,y,w,h)
    self.x = x or WIDTH-500
    self.y = y or 170 
    self.w = w or 200
    self.h = h or 30
    
    --note: the next statement gets makes an instance (new) UI text view that you can use to make a GUI textbox
    self.uiTextView = objc.UITextView:alloc():initWithFrame_(objc.rect(x, y, w, h))
    
    --note: the next statement gets the actual UIViewController running in Codea
    local vc = objc.viewer
    vc.view:addSubview_(self.uiTextView)
    
    --note: need to make the next ObjC statement false to allow use of advanced Apple ObjC display formatting constraints
    self.uiTextView.translatesAutoresizingMaskIntoConstraints = false
    -- Apple's ObjC GUI objects like uiTextView allow lots of customization
    self.uiTextView.layer.cornerRadius = 10
    
    
    -- 如果有加载的模型，则使用模型原来的名字进行保存
    if itemPanel.slot then
        self.uiTextView.text = itemPanel.slot.block.name 
    else
        -- self.uiTextView.text = os.date("%Y%m%dT%H%M%S") .. ".cvox"
        self.uiTextView.text = " " .. ".cvox"
    end
    
    -- placeholder variable for what user types in the textbox
    typedText=""
    
    --create a delegate to work with the UITextView that will sense when changes are made to the textbox
    Delegate = objc.delegate("UITextViewDelegate")
    
    function Delegate:textViewShouldBeginEditing_(objTextView)
        -- replace with false to prevent editing textbox
        return true
    end
    
    -- 如果文本框修改则触发
    function Delegate:textViewDidChange_(objTextView)        
        typedText = objTextView.text
        -- print("changed text:", typedText)
    end
    
    -- 文本框结束编辑则触发
    function Delegate:textViewDidEndEditing_(objTextView)
        typedText = objTextView.text
        name = typedText
        -- print("saved name", name)
        -- print("end select: ", b.selected) 
        
        -- 保存当前模型
        -- 把模型保存到本项目文件夹中，带来一个问题，版本升级可能会覆盖掉用户的模型
        -- volume:save(asset.models .. name)
        volume:save(asset.documents.MyAmuseModels .. name)
        if shareModel then
            -- 把模型保存到 Codea 的公共文件夹 Documents 中，方便其他项目使用模型
            volume:save(asset.documents .. name)  
        end      
    end
    
    -- set delegate to textView AFTER you've created the delegate above
    self.uiTextView.delegate = Delegate()
end


function ObjcTextBox:endEditing()
    -- 结束输入，关闭键盘，隐藏文本框
    self.uiTextView:endEditing_(true)
    self.uiTextView.hidden = true
    
    ---[[ 检查是否有同名模型，没有则追加到 self.volumes 中，现存问题还无法立即同步显示到模型清单面板上
    local name = self.uiTextView.text
    local dupFlag = itemPanel:checkDup(name)
    if not dupFlag then
        -- 把新保存的模型追加到 self.volumes 中
        -- itemPanel:appendItem(asset.models .. name)
        itemPanel:appendItem(asset.documents.MyAmuseModels .. name)
    end
    --]]
end

function ObjcTextBox:cancelEditing()
    -- 结束输入，关闭键盘，隐藏文本框
    --self.uiTextView:endEditing_(true)
    self.uiTextView.hidden = true
end

--[[
function objcTextBox1()
    local vc = objc.viewer
    
    uiTextView = objc.cls.UITextView()
    vc.view:addSubview_(uiTextView)
    
    uiTextView.translatesAutoresizingMaskIntoConstraints = false
    uiTextView.trailingAnchor:constraintEqualToAnchor_constant_(vc.view.trailingAnchor, -20).active = true
    uiTextView.topAnchor:constraintEqualToAnchor_constant_(vc.view.topAnchor, 220).active = true
    uiTextView.widthAnchor:constraintEqualToConstant_(100).active = true
    uiTextView.heightAnchor:constraintEqualToConstant_(20).active = true
    
    uiTextView.text = ""
    uiTextView.layer.cornerRadius = 8
    
    AllowBeginEditing =true
    
    Delegate = objc.delegate("UITextViewDelegate")
    
    function Delegate:init(test)
        self.test = test
    end
    
    function Delegate:textViewShouldBeginEditing_(objTextView)
        return AllowBeginEditing
    end
    
    function Delegate:textViewDidChange_(objTextView)
        print(self.test .. ": " .. objTextView.text)
    end
    
    function Delegate:textViewDidEndEditing_(objTextView)
        typedText = objTextView.text
        name = typedText..".cvox"
        print("saved name", name)
        print("end select: ", b.selected)        
        -- volume:save("Documents:"..name)
    end
    
    uiTextView.delegate = Delegate("uiTextView")
    return uiTextView
end
--]]

----