-- 选择建模单位方块，通过 unit 打开面板

UnitPanel = class()

function UnitPanel:init()
    self.isInventoryOpen = false
    self.myInventory = nil
    self.myhotbar = nil
    self.slot = nil
    self.blockIconPath = asset.blockIcons
    
    -- 方块清单主面板 self.myInventory 的行，列，单位尺寸大小
    self.mRows = 10
    self.mCols = 8
    self.mGSize = 64
    
    -- 面板的长度，宽度
    -- local w,h =
    -- self.gridCols * self.gridSize + self.border * 2 + (self.gridCols-1) * self.spacing,
    -- self.gridRows * self.gridSize + self.border * 2 + (self.gridRows-1) * self.spacing
    local panelW, panelH =
    self.mCols * self.mGSize + 5*2 + (self.mCols-1)*5, 
    self.mRows * self.mGSize + 5*2 + (self.mRows-1)*5 
    
    -- 新建一个背景 panel，可作为本类中所有控件的父节点
    self.panel = ui.panel
    {
        pivot = vec2(0.5, 1.0),
        anchor = vec2(0.5, 2.0),
        w = panelW,
        h = panelH,
        align = {h = ui.CENTER, v = ui.TOP},
        -- bg = "UI:Grey Panel",
        bg = asset.builtin.UI.Grey_Panel,
        fill = color(0, 32),
        inset = 10,
    }
    
    -- 创建右侧的竖条色彩选择面板，暂时只用于 Solid 类型
    self.colorPanel = ColorPanel(300,HEIGHT-60,WIDTH-350,40)
    
    -- 创建物品仓库面板
    self.myInventory = Inventory(self.mRows, self.mCols, self.mGSize, 5,5,function() end)
    self.myInventory.itemCallback = function(inventory, slot)
        -- 获取 hotbar 中的选项
        local hotbarSlot = self.myhotbar:getSelected()
        -- print("UnitPanel hotbarSlot: ", hotbarSlot)
        if hotbarSlot and slot.block then
            local block = slot.block
            -- 最后一个槽位固定设置为 Solid(纯色方块)，不允许更改
            if hotbarSlot.index ~= self.myhotbar:slotCount() then
                -- inventory.title.text = string.upper( block.longName or block.name )            
                inventory.title.text = block.longName or block.name
                self.myhotbar:setItem(hotbarSlot.index, block)    
                -- self.hotbar:save("Project:Hotbar")
                self.myhotbar:save(asset.."UnitPanelHotbar.txt")
            end
            
            sound(SOUND_PICKUP, 41674)   
            
            
            ---[[ 若通过点击定制方块使用非 Solid 类型做为基本单元建模，则关闭右侧颜色选择菜单
            if block.name == "Solid" then
                -- print("open color,block.name ",block.name)
                self.colorPanel:slide(1.5, 0.3)
            else 
                -- print("点击大矩形面板内的定制方块，关闭右侧颜色竖条")
                self.colorPanel:slide(2.5, 0.3)
            end
            --]]
            
            -- 回调函数：点击某槽位，则根据该槽位对应索引从 volumes 中选择模型，加载到当前编辑区
            -- self:loadVolumeModel(volume, self.volumes[slot.index])  
            tool.toolUnitType = block.name
        end
    end
    
    -- 把所有 block 都加入 self.myInventory 面板上的槽位中
    self:getAllBlocks()
    
    -- 创建最下方的常用方块选择快捷条，在这里控制开启/关闭 self.colorPanel
    self.myhotbar = Inventory(1, 10, 48, 5, 5, function() end)
    self.myhotbar.itemCallback = function(inventory, slot)
        inventory:setSelected(slot)
        self.slot = slot
        
        local block = slot.block
        
        if block then            
            ---[[ 若通过点击 hotbar 左侧来使用非 Solid 类型做为基本单元建模，则关闭右侧颜色选择菜单
            if block.name == "Solid" then
                -- print("hotbar open color ", block.name)
                self.colorPanel:slide(1.5, 0.3)
            else 
                -- 点击底部 hotbar 的定制方块(不包括最右 Solid 按钮)，关闭右侧颜色竖条，注释该行
                -- self.colorPanel:slide(2.5, 0.3)
            end
            --]]
            
            -- 选择要使用的方块类型
            tool.toolUnitType = block.name
            sound(SOUND_PICKUP, 41674)   
        end       
    end
    
    -- 创建用于开启整个 UnitPanel 子菜单的按钮，控制单位方块类型/颜色选择菜单的显示/隐藏
    self.controlButton = ControlButton(1,1,50,50,"unit")
    -- self.controlButton.title.anchor = vec2(0.5,0.5)
    self.controlButton.button.onPressed=function(b) 
        -- 打开二级菜单，设置
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)          
        if b.selected then
            -- 打开
            b.label.text = "close"
            -- unitPanel:close(0.0, 0.6)
        else
            b.label.text = "unit"
            -- unitPanel:open(0.0, 2.1)
        end
        -- 根据参数 self.isInventoryOpen 确定显示/隐藏 UnitPanel
        unitPanel:showInventory()
    end
    
    
    -- 统一加入 self.panel 子节点，方便 UI 布局
    -- self.panel:addChild(self.colorPanel) 
    self.panel:addChild(self.myInventory.panel) 
    -- 把颜色选择面板和快捷面板绑定
    -- self.myhotbar.panel:addChild(self.colorPanel)
    
    ---[[ 设置右侧竖条颜色(ColorPanel)选择面板的位置布局，始终显示，不隐藏
    self.colorPanel.pivot = vec2(1.0, 0.5)
    self.colorPanel.anchor = device.ColorPanel.show -- vec2(2.5, 0.3)/(1.6, 0.3)
    self.colorPanel.align = {h=ui.RIGHT, v=ui.BOTTOM}
    --]]
    
    -- 设置定制方块(UnitPanel)选择面板的位置布局
    self.myInventory.panel.pivot = vec2(0.5, 0)
    self.myInventory.panel.anchor = device.UnitInv.show -- vec2(0.5, 0)
    -- self.myInventory.panel.anchor = vec2(0.85, 0.75)
    self.myInventory.panel.align = {h=ui.CENTER, v=ui.BOTTOM}
    
    -- 设置底部快捷条的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.myhotbar.panel.pivot = vec2(0.5, 0.0)
    self.myhotbar.panel.anchor = device.UnitHotbar.show -- vec2(0.5, 0.02)
    self.myhotbar.panel.align = {h=ui.CENTER, v=ui.BOTTOM}
    
    -- 设置顶部控制按钮的位置布局，把它单独处理，不加入子节点，它始终处于显示状态，不会隐藏收起
    self.controlButton.panel.pivot = vec2(1.0, 1.0)
    self.controlButton.panel.anchor = vec2(0.85, 0.99)
    self.controlButton.panel.align = {h=ui.CENTER, v=ui.TOP}
    
    
    -- 设置底部快捷条最后一个选项固定为 Solid
    local lastSlot = self.myhotbar:getSlot(self.myhotbar:slotCount())
    -- print("self.hotbar:slotCount(): ", self.myhotbar:slotCount())
    -- lastSlot.button.label.text = "Solid"
    lastSlot.button.icon.img = solid.static.icon
    lastSlot.button.normalBg = asset.builtin.UI.Blue_Button11
    lastSlot.button.highlightedBg = asset.builtin.UI.Blue_Button10
    lastSlot.button.selectedBg=asset.builtin.UI.Blue_Box_Tick
    -- 在底部 hotbar 最右的 Solid 键位，覆盖前面的回调函数  self.myhotbar.itemCallback
    lastSlot.button.onPressed = function(b)
        b.selected = not b.selected
        sound(SOUND_PICKUP, 41674)      
        
        -- 若通过点击 hotbar 最右侧使用 Solid 类型做为基本单元建模，则弹出右侧竖条颜色选择菜单
        -- self.colorPanel:slide(anchor(device.ColorPanel.show)) --(1.6, 0.3) 
        
        -- 打开新色彩面板
        newColorPanel:showInventory()
        
        -- 使用最基本的纯色方块 Solid
        tool.toolUnitType = "Solid"
        
        -- 当选中最后一格的 Solid 时，其他 slot 置为 false
        self.myhotbar:setSelected(lastSlot)
        self.myhotbar:save(asset.."UnitPanelHotbar.txt")
        -- 关闭方块选择面板，只保留 ColorPanel
        -- self:close(0.1, 1.6)
    end
    --]]
    
    -- 加载保存好的快捷条选择文件存档
    self.myhotbar:load(asset.."UnitPanelHotbar.txt")
    -- 设置当前方块选择为快捷条中的选择
    self.slot = self.myhotbar.selected    
end

-- 显示/隐藏 (0.9, 1.0)/(0.9, 0.1)
function UnitPanel:slide(x,y)
    tween(0.6, self.panel.anchor, {x=x or 0.9, y = y or 1.0}, tween.easing.cubicInOut)
end

-- 显示物品清单
function UnitPanel:showInventory()
    if self.isInventoryOpen then
        self:slide(anchor(device.UnitPanel.hide)) -- (0.5, 1.8)
        self.myInventory:slide(anchor(device.UnitInv.hide)) -- (0.0, 1.8)
        -- self.colorPanel:slide(anchor(device.ColorPanel.hide)) --(1.6, 0.3) 
        self.isInventoryOpen = false
    else
        self:slide(anchor(device.UnitPanel.show)) -- (0.5, 0.88)
        self.myInventory:slide(anchor(device.UnitInv.show)) --(0.0, 0.0)
        -- self.colorPanel:slide(anchor(device.ColorPanel.show)) --(1.6, 0.3) 
        self.isInventoryOpen = true       
    end
end

function UnitPanel:draw()    
    self.panel:update()
    self.panel:draw()
    
    -- 3个独立布局的按钮，不受 self.panel 布局参数的影响
    self.myhotbar:draw()
    
    self.colorPanel:draw()
    
    self.controlButton:draw()
end

--[[
function UnitPanel:getAllVolumes()
    -- 这里指定加载模型所在的文件夹路径
    -- files = assets or asset.all or asset.documents.all
    
    -- 遍历目录中所有的voxel模型
    for k,v in pairs(self.files) do
        if v.ext == "cvox" then 
            -- print(v.name)
            
            -- 改造为跟block一致的表结构，可以合并代码，尽量使用 Inventory 原来的流程，减少循环
            local block = {model=v, hasIcon=true, icon=nil}
            
            table.insert(self.volumes,v)            
        end
    end
    -- print("Volumes Model Numbers: ",table.unpack(volumes))
    
    -- 生成每个模型的预览图像，用于在选择列表中显示小图标
    for i=1,#self.volumes do
        local modelImg = self:generateModelPreview(self.volumes[i])
        table.insert(volumeIcons, modelImg)
    end        
end
--]]

function UnitPanel:getAllBlocks()
    -- 遍历所有方块 block，将所有的方块都当作基本单位添加入仓库中
    for k,v in pairs(allBlocks) do
        if v.canPlace then
            self.myInventory:addItem(v)
        end
    end
end


-- Uses the camera to generate previews of blocks before the scene starts
function UnitPanel:generateUnitPreview(block)
    
    -- Try to read a cached version of the icon first
    -- local img = readImage("Project:"..block.name)
    -- 在本地目录下新建文件夹 unit，专门保存各种方块单元的图标
    -- local img = readImage(asset..block.name)
    local img = readImage(self.blockIconPath..block.name)
    
    if img then
        return img
    end
    
    local camera = scene.camera:get(craft.camera)
    local sky = scene.sky
    
    local ortho = camera.ortho
    local orthoSize = camera.orthoSize
    
    --[[ 
    pb = craft.bloomEffect()
    pb.enabled = true 
    pb.iterations = 5
    pb.threshold = 0.06
    pb.softThreshold = 1.6
    pb.intensity = 0.06
    
    camera.hdr = true
    camera.colorTextureEnabled = true
    camera.clearDepthEnabled = true
    camera.clearColorEnabled = true
    camera.depthTextureEnabled = true
    camera:addPostEffect(pb)
    --]]
    
    camera.ortho = false
    camera.orthoSize = 20.9
    camera.entity.rotation = quat.eulerAngles(35, 45, 0)
    camera.entity.position = vec3(0.5, 10.5, 0.5) - camera.entity.forward * 50
    camera.clearColorEnabled = false
    -- 将 sky 设置为 false 可以得到背景透明的预览图标
    sky.active = false
    
    -- 加载方块形体
    local volumeObj = scene:entity()
    local volume = volumeObj:add(craft.volume, 1, 1, 1)   
    -- volume.model:getMaterial().showOutline = true
    -- volumeObj.scale= vec3(0.1,0.1,0.1)
    
    -- 实际执行模型加载
    -- self:loadVolumeModel(volume, model)
    -- 手工处理 tinted
    if block.tinted then
        volume:set(0,0,0,"name", block.name, "color", color(241, 19, 23))        
    else
        volume:set(0,0,0, block.name)
    end
    
    -- 为 model 拍照
    img = image(128, 128)
    setContext(img, true)
    camera:draw()
    setContext()
    
    volumeObj:destroy() 
    
    camera.ortho = ortho
    camera.orthoSize = orthoSize
    camera.clearColorEnabled = true
    sky.active = true
    
    -- saveImage(asset..block.name, img)
    saveImage(self.blockIconPath..block.name, img)
    return img 
end

----