----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
Oil = {}

--- @module Oil
-- Entry to the Oil UI library.

-- New global values
TOP = "top"
BOTTOM = "bottom"

-- Axis types
AXIS_NONE = 0
AXIS_X =  1
AXIS_Y =  2
AXIS_XY = 3

--- @function Oil.setup ()
-- Call in your setup function to initialise the Oil UI library.
function Oil.setup(bbw, bbh)
    
    -- Initialise UIKit
    UIKit.setup()
    
    -- Create framebuffer
    Oil.bbw = bbw or WIDTH
    Oil.bbh = bbh or HEIGHT
    Oil.fb = image(Oil.bbw, Oil.bbh)
    
    -- Init root node
    Oil.root = Oil.Node(0, 0, Oil.bbw, Oil.bbh)
    Oil.root.style_default = Oil.style_default
    Oil.root:set_debug_name("root")
end

--- @function Oil.beginDraw ()
-- Call at the start of your draw() function to ensure that rendering is done to Oil's internal framebuffer. This must be done to ensure that gaussian blur can correctly be applied to elements rendered outside of the Oil library.
-- @usage function draw()
--     Oil.beginDraw()
--
--     background(64) -- render a grey background.
--
--     -- Other user rendering here
--
--     Oil.endDraw()
-- end
function Oil.beginDraw()
    assert(Oil.fb ~= nil, "It doesn't look like Oil is initialised. Have you called Oil.setup() yet?")
    setContext(Oil.fb)
end

--- @function Oil.endDraw ()
-- Call at the end of your draw() function to ensure that UI is processed and rendered to the screen.
-- @usage function draw()
--     Oil.beginDraw()
--
--     background(64) -- render a grey background.
--
--     -- Other user rendering here
--
--     Oil.endDraw()
-- end
function Oil.endDraw()
    -- Update touches
    update_touches()
    
    -- Update nodes
    Oil.root:update()
    Oil.root:post_update()
    
    -- Draw nodes
    setContext(Oil.fb)
    Oil.root:draw()
    setContext()
    
    -- Blit to screen
    ortho(0, WIDTH, 0, HEIGHT)
    spriteMode(CORNER)
    sprite(Oil.fb, 0, 0, WIDTH, HEIGHT)
end

--- @function Oil.sizeChanged (w, h)
-- Should be called by the user when the window dimensions change.
-- Usually called from within Codea's sizeChanged() callback function.
-- @param w New width
-- @param h New height
-- @usage function sizeChanged(w, h)
--     Oil.sizeChanged(w, h) -- Update Oil with new sizes
-- end
function Oil.sizeChanged(w, h)
    if Oil.root == nil then
        return
    end
    
    -- Regenerate framebuffer
    Oil.fb = image(w, h)
    
    -- Resize root node
    Oil.root.w = w
    Oil.root.h = h 
end



-- Clip management
local clip_stack = {}
function Oil.clip(x, y, w, h)
    
    if #clip_stack > 0 then
        local old = clip_stack[#clip_stack]
        local r = x + w
        local t = y + h
        x = math.max(old.x, x)
        y = math.max(old.y, y)
        w = math.max(math.min(old.x + old.z, r) - x, 0)
        h = math.max(math.min(old.y + old.w, t) - y, 0)
    end
    
    clip(x, y, w, h)
    table.insert(clip_stack, vec4(x, y, w, h))
end

function Oil.clipPop()
    table.remove(clip_stack)
    
    -- Re-apply clip
    local len = #clip_stack
    if len > 0 then
        local c = clip_stack[len]
        clip(c.x, c.y, c.z, c.w)
    else
        clip()
    end
end
