local socket = require('socket')

tween.delay(0.1, function()

function accumulate(n)
    local acc = 0
    for i=1,n do
        acc = acc + i
    end
    return acc
end

local function otherFunction()
	print("I'm an upvalue function!")
end

local message = "Hello Parallel Lua!"
function test()
	print(message)
	otherFunction()
end

-- Import functions directly into parallel instance
local pll = parallel({
	accumulate = accumulate,
	test = test
})

-- OR load the instance functions from source
-- local pll = parallel.instance([==[
--     function accumulate(n)
--         local acc = 0
--         for i=1,n do
--             acc = acc + i
--         end
--         return acc
--     end
-- ]==])

pll.test()

--  Run our simple comparison case
local TEST_N = 1000000

-- Measure time of local function
ts = socket.gettime()
	accumulate(TEST_N)
te = socket.gettime()
print("Local took:" .. (te - ts))
    
-- Measure time of parallel function
ts = socket.gettime()
	local result = pll.accumulate(TEST_N):result()
te = socket.gettime()
print("Parallel Took:" .. (te - ts))

print("Running again without blocking...")
pll.accumulate(TEST_N):next(function(result)
    print("Received async result! " .. result[1])
end)
    
function draw()
    print("draw")
    background(30, 100, 30)
end
    
end)
