local mime = require("mime")

local btoa = mime.b64
local atob = mime.unb64

-- Encodes strings into base64
local function b64(v)
	if type(v) == "string" then return btoa(v) end
	if type(v) == "table" then
		local t = {}
		for k,v in pairs(v) do
			t[k] = b64(v)
		end
		return t
	end
	return v
end

-- Decodes strings from base64
local function unb64(v)
	if type(v) == "string" then return atob(v) end
	if type(v) == "table" then
		local t = {}
		for k,v in pairs(v) do
			t[k] = unb64(v)
		end
		return t
	end
	return v
end

return {
	b64 = b64,
	unb64 = unb64
}