-- We are currently unable to load more than one instance so
-- if you want to use the REPL you can ONLY use the REPL.
local USE_REPL = true

-- Delay so the Lib can load first
-- (This isn't needed when used as a dependency)
tween.delay(0.1, function()  

local rSource = [==[
    # A simple addition function
    add <- function(a, b) {
        res <- a + b
        c(a, b, res)
    }
    
    # Test of 2D plotting
    plot2d <- function(res) {
        # Set the canvas resolution
        webr::canvas(res, res)
    
        # Plot our values!
        plot(rnorm(1000), rnorm(1000), col=rgb(0,0,0,0.5),
            xlim=c(-5, 5), ylim=c(-5, 5), main="This is the title",
            xlab="This is the x label", ylab="This is the y label")
    }
    
    # Test of 3D plotting
    plot3d <- function(res) {
        # Set the canvas resolution
        webr::canvas(res, res)
    
        # Adding Titles and Labeling Axes to Plot
        cone <- function(x, y){
            sqrt(x ^ 2 + y ^ 2)
        }
        
        # prepare variables.
        x <- y <- seq(-1, 1, length = 30)
        z <- outer(x, y, cone)
        
        # plot the 3D surface
        # Adding Titles and Labeling Axes to Plot
        persp(x, y, z,
            main="Perspective Plot of a Cone",
            zlab = "Height",
            theta = 30, phi = 15,
            col = "orange", shade = 0.5)
    }
]==]

if USE_REPL then
        
    -- Start a REPL with some code pre-loaded
    R = R.repl(rSource)
        	
    -- Plot the 3D cone example
    R("plot3d(" .. math.min(HEIGHT,WIDTH) .. ")") -- no print
        	
    -- In the Codea command field you can then enter code:
    -- Input:	R("c(0, 3, 9)")
    -- Output:	[0,3,9]
        	
    -- Input:	R("9+10")
    -- Output:	19
        	
    -- Input:	R("plot3d(400)")
    -- Output:	3D cone plot displayed!
        
else
	
	local instance = R(rSource)
	
	-- Simple example (blocking)
	local r = instance.add(3, 4):waitForResult()
	print(json.encode(r)) -- prints '[3, 4, 7]'
	
	-- Simple example (non-blocking)
	instance.add(7, 3):next(function(r)
	    print(json.encode(r)) -- prints '[7, 3, 10]'
	end)
	    
	-- Plot 3D demo!
	local r = instance.plot3d(HEIGHT) -- Swap for 'plot2d' to test the other func
	r:onplot(function(plot, isNewPlot) -- This is an async callback
	    _ENV.plot = plot
	end)
	r:next(function() -- Callback when the call completes
	    print("Plot complete.")
	end)
	    
	-- Draw our plot
	function draw()
	    background(255)
	    if plot then
	        spriteMode(CENTER)
	        sprite(plot, WIDTH/2, HEIGHT/2, HEIGHT, HEIGHT)
	    end
	end
end
    
end)
