// Download WebR runtime
const { WebR, WebRDataJsNode, ChannelType, isRFunction } = await import('https://webr.r-wasm.org/latest/webr.mjs');

// Initialise WebR
let webR;
try {
	webR = new WebR({
		channelType: ChannelType.PostMessage,
	});
	await webR.init();
} catch(e) {
	error(e.message);
}

// Set default render device
await webR.evalRVoid('options(device=webr::canvas)');

// Load the R code
const code = await codea.recv();
await webR.evalR(code);

// Our plot canvas
let gfxReceiverId = -1;
let canvas = new OffscreenCanvas(1008, 1008);
let isNewCanvas = false;
let seenPrompt = false;

// Async message handler
(async ()=>{
	while (true) {
		const output = await webR.read();
		switch(output.type) {
			case "stdout":
				if (seenPrompt === true) { print(output.data); }
				break;
			case "stderr":
				if (seenPrompt === true) { warn(output.data); }
				break;
			case "prompt":
				// print(output.data);
				seenPrompt = true;
				break;
			case "canvas":
				if (gfxReceiverId === -1) {
					break;
				}
			
				if (output.data.event === 'canvasImage') {
					const width = output.data.image.width;
					const height = output.data.image.height;
					
					// Is the canvas the correct size
					// or should we create a new one anyway?
					if (canvas.width != width ||
						canvas.height != height || isNewCanvas == true)
					{
						canvas = new OffscreenCanvas(width, height);
						isNewCanvas = true;
					}
					
					// Draw to our canvas
					canvas.getContext('2d').drawImage(output.data.image, 0, 0);
					
					// Prepare and send our updated image
					let data = await canvas.convertToBlob();
					data = await data.arrayBuffer();
					data = new Uint8Array(data);
					
					codea.send({
						data: {
							data: data,
							isNewPlot: isNewCanvas
						},
						id: gfxReceiverId
					});
					isNewCanvas = false;
				
				} else if (output.data.event === 'canvasNewPage') {
					isNewCanvas = true;
				}
				break;
			default:
				print("R message:", output.type);
				break;
		}
	}
})();

// Signal to Codea that the instance is ready
codea.send("_ready_");