// Main invocation loop
while (true) {
	const inv = await codea.recv();
	try {
		let result;
		switch(inv.op) {
			case "read":
			{
				result = await webR.evalR(inv.key);
				if (isRFunction(result)) {
					codea.send({
						data: {
							fn: inv.key
						},
						id: inv.id
					});
				} else {
					result = await result.toJs();
					codea.send({
						data: result,
						id: inv.id
					});
				}
			}
			break;
			case "write":
			{
				let fn = await webR.evalR("function(v) {" + inv.key + " <<- v }");
				
				let value = inv.value;
				if (typeof value === "object") {
					//print(JSON.stringify(inv.value));
					if (Array.isArray(inv.value) &&
						inv.value.every((val, i, arr) => typeof val === typeof inv.value[0])) {
						value = await new webR.RObject(inv.value);
					} else {
						value = await new webR.RList(inv.value);
					}
					//print(JSON.stringify(await value.toJs()));
				}
				fn.exec(value);
				
				// Signal that the write is complete
				codea.send({
					data: null,
					id: inv.id
				});
			}
			break;
			case "call":
			{
				let fn = await webR.evalR(inv.fn);
				if (isRFunction(fn)) {
					result = await fn(...inv.args);
					if (isRFunction(result)) {
						warn("Unable to return functions currently!");
					} else {
						codea.send({
							data: result,
							id: inv.id
						});
					}
				} else {
					error("Attempt to call non function value: " + inv.fn);
				}
			}
			break;
			case "eval":
			{
				result = await webR.evalR(inv.expr);
				if (isRFunction(result)) {
					codea.send({
						data: {
							fn: inv.expr
						},
						id: inv.id
					});
				} else {
					result = await result.toJs();
					codea.send({
						data: result,
						id: inv.id
					});
				}
			}
			break;
			case "setGfxReceiver":
			{
				gfxReceiverId = inv.gfxId;
			}
			break;
		}
	} catch(e) {
		error(e.message);
	}
}