-- Require the implementation
Impl = require("impl/impl")

local WorkerManager = require('workers')
local webview = require('webview')
local base64 = require("base64")

local b64 = base64.b64

-- Class declarations
local RInstance = class()
local RRepl = class()

local POOL_SIZE_INITIAL = Impl.config.workerPoolInitial
local POOL_SIZE_MINIMUM = Impl.config.workerPoolMinimum

-- Create JS environment & channel manager
local wv = webview()
local wm = WorkerManager(Impl.config.connectionPort or 6767, wv)

local workerPool = {}
local function initThreadPool(num)
	for i=1,num do
		-- Add new worker to pool
		local worker = wm:newWorker()
		table.insert(workerPool, worker)
	end
end
initThreadPool(POOL_SIZE_INITIAL)

Impl.auto.getWorker = function()
	-- Get from workerPool
	local w = table.remove(workerPool)
	
	-- Add new worker to the pool
	-- TODO: This needs to be nonblocking
	if #workerPool < POOL_SIZE_MINIMUM then
		local worker = wm:newWorker()
		table.insert(workerPool, worker)
	end
	
	return w
end

-- Setup default function
local exports = setmetatable({}, {
	__call = function(_, ...)
		return Impl.exports.default(...)
	end	
})

-- Load exported functions from implementation
for fnName,fn in pairs(Impl.exports) do
	exports[fnName] = fn
end

-- Add automated update function
exports.updatePerFrameLimit = 256
local _tweenup = tween.update
tween.update = function(...)
	_tweenup(...)
	wm:update(limit or exports.updatePerFrameLimit)
end

-- Set global
return {
	[Impl.config.projectName] = exports
}