const b64 = (v)=>{
	if (typeof v == "string") {
		return btoa(v)
	}
	if (v instanceof Uint8Array) {
		return btoa(Array.from(v, (x) => String.fromCodePoint(x)).join(""))
	}
	if (v instanceof Array) {
		const arr = new Array();
		for (var i = 0; i < v.length; i++) {
			arr[i] = b64(v[i]);
		}
		return arr;
	}
	if (v instanceof Object) {
		const o = new Object();
		for (k in v) {
			o[k] = b64(v[k]);
		}
		return o;
	}
	return v;
};

const unb64 = (v)=>{
	if (typeof v == "string") {
		return atob(v);
	}
	if (v instanceof Array) {
		const arr = new Array();
		for (var i = 0; i < v.length; i++) {
			arr[i] = unb64(v[i]);
		}
		return arr;
	}
	if (v instanceof Object) {
		const obj = new Object();
		for (var k in v) {
			obj[k] = unb64(v[k]);
		}
		return obj;
	}
	return v;
};

class Codea {
	constructor() {
		this.messages = new Array();
		
		this.ws = new WebSocket(`ws://localhost:6767`);

		// Set message handler
		this.ws.onmessage = (e)=>{
			try {
				const payload = JSON.parse(e.data);
				const msg = unb64(payload.data);
				
				if (this.signal !== undefined) {
					this.signal(msg);
					this.signal = undefined;
				} else {
					this.messages.push(msg);
				}
			} catch(e) {
				error(e.message);
			}
		};
	}
	
	send(msg) {
		// Ensure any strings or lua strings in the msg are encoded to base64.
		const b64msg = b64(msg);
		
		let payload = {
			data: b64msg
		};
		
		payload = JSON.stringify(payload);
		this.ws.send(payload);
	}
	
	recv() {
		return new Promise((resolve)=>{
			if (this.messages.length > 0) {
				resolve(this.messages.shift());
			} else {
				this.signal = resolve;
			}
		});
	}
	
	print(...args) {
		const str = args.reduce((acc, c) => acc + "\t" + c, "").substring(1);
		postMessage("print:" + str);
	}
	
	error(msg) {
		postMessage("error:" + msg);
	}
	
	warn(msg) {
		postMessage("warn:" + msg);
	}
};
	
self.codea = new Codea();

// Set globals
self.print = codea.print;
self.error = codea.error;
self.warn = codea.warn;

// The worker loop
(async ()=>{
	
	// Send ready signal when the websocket is connected
	codea.ws.onopen = ()=>{
		codea.send("_ready_");
	};
	
	while (true) {
		try {
			const invocation = await codea.recv();
		
			const code = `
				return new Promise(async (resolve)=>{
					async function fn(args) {
						${invocation.code}
					}
					resolve(await fn(args));
				});`;
				
			const fn = new Function("args", code);
			const results = await fn(invocation.args);
			
			codea.send(results);
		
		} catch(e) {
			error(e.message);
		}
	}
})();
