-- We are currently unable to load more than one instance so
-- if you want to use the REPL you can ONLY use the REPL.
local USE_REPL = true

-- Delay so the Lib can load first
-- (This isn't needed when used as a dependency)

function draw()
    local rSource = [==[
        plot3d <- function() {
            # Adding Titles and Labeling Axes to Plot
            cone <- function(x, y){
                sqrt(x ^ 2 + y ^ 2)
            }
            
            # prepare variables.
            x <- y <- seq(-1, 1, length = 30)
            z <- outer(x, y, cone)
            
            # plot the 3D surface
            # Adding Titles and Labeling Axes to Plot
            persp(x, y, z,
                main="Perspective Plot of a Cone",
                zlab = "Height",
                theta = 30, phi = 15,
                col = "orange", shade = 0.5)
        }
    ]==]
    
    if USE_REPL then
        
        -- Info: Calling an R instance object behaves like a REPL (Result is printed and not returned). 
        
        -- Create a new R instance and pre-load
        -- some code.
        -- We replace the 'R' variable with the
        -- new instance.
        R = R(rSource, true) -- true = print the REPL intro message
        
        -- Plot the 3D cone example
        R("plot3d()", true) -- silent
            	
        -- In the Codea command field you can then enter code:
        -- Input:	R("c(0, 3, 9)")
        -- Output:	[0,3,9]
            	
        -- Input:	R("9+10")
        -- Output:	19
            	
        -- Input:	R("plot3d()")
        -- Output:	3D cone plot displayed!
    
    else
        -- Everything is synchronous by default (except graphics)
        
        local instance = R([=[
            X <- 456
         ]=])
        
        -- FS behaves similarly to Codea assets.
        -- instance.FS represents the root '/'.
        --
        -- Entries contain the values:
        -- name - file name
        -- isFolder - true or false
        -- id - FS node ID.
        local info = instance.FS.info
        print("info /\n", json.encode(info))
        
        -- .all returns contents of the folder as a table.
        -- List all files in /home/web_user
        -- (Hint: there are no files so this prints an empty array but you get the gist)
        local dirListing = instance.FS.home.web_user.all
        print("ls /home/web_user\n" .. json.encode(dirListing))
        
        -- Direct file system writes
        instance.FS["test.txt"] = "Hello World!"
        
        -- Use .content to read a file
        print("cat /test.txt\n" .. instance.FS["test.txt"].content)
        
        -- New listing after file write will include new file too
        dirListing = instance.FS.all
        print("ls /\n" .. json.encode(dirListing))
        
        -- Install packages example (commented for speedup)
        -- instance.installPackages("Matrix")
            
        -- Get variable
        print("X = " .. instance.X)
        
        -- Modify variable
        instance.X = 2
        print("New X = " .. json.encode(instance.X))
        
        -- Add a new variable
        instance.Y = { 9, 5, 0 }
        print("Y = " .. json.encode(instance.Y))
        
        -- Evaluate arbitrary expression
        print("Y * X = " .. json.encode(instance["Y*X"]))
        
        -- Can assign lists to R variables
        instance.Y = { 9, 5, "Hello" }
        print(json.encode(instance.Y))
        
        -- Get dataframe in Lua table format
        local mtcars = instance.asLuaDF.mtcars
        local carName = "Mazda RX4 Wag"
        local carInfo = mtcars[carName]
        print(carName .. ": " .. json.encode(carInfo))
        
        -- Can also read dataframe with plain index
        local carIndex = 5
        carInfo = mtcars[carIndex]
        carName = mtcars._nameOf(carIndex)
        print(carName .. ": " .. json.encode(carInfo))
        
        -- Load an extra function
        instance.eval([[
            add <- function(a,b) {
                a + b
            }
        ]])
            
        -- Blocking call (this will wait for the result before printing)
        local r = instance.add(3, 4)
        print("3 + 4 = " .. tostring(r))
        
        -- Non-blocking call
        instance.async_add(3, 4):next(function(r)
            print("async 3 + 4 = " .. tostring(r))
        end)
                
        -- Load a plot2d function
        instance.eval([[
            plot2d <- function() {
                # Plot our values!
                plot(rnorm(1000), rnorm(1000), col=rgb(0,0,0,0.5),
                xlim=c(-5, 5), ylim=c(-5, 5), main="This is the title",
                xlab="This is the x label", ylab="This is the y label")
            }
        ]])
                
        -- Graphics are drawn automatically by default.
        instance.plot2d()
        
        -- We could also set a callback to trigger
        -- each time graphics are drawn. This allows
        -- us to save images or incorporate them
        -- into custom draw() functions.
        instance.gfx:setFn(function(img, new)
            -- Do something with img.
        end)
    end
end
